/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.command.admin;

import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.lib.command.IHandyCommandEvent;
import cn.handyplus.monster.lib.core.YmlUtil;
import cn.handyplus.monster.lib.util.AssertUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.MonsterSpawnDataParam;
import cn.handyplus.monster.util.ConfigUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CreateSpawnCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "createSpawn";
    }

    @Override
    public String permission() {
        return "monsterPlus.createSpawn";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        AssertUtil.notPlayer(sender, BaseUtil.getLangMsg("noPlayerFailureMsg"));
        Player player = (Player)sender;
        String type = args[1].toUpperCase();
        Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnum(type);
        if (!monsterTypeEnumOptional.isPresent()) {
            MessageUtil.sendMessage(sender, BaseUtil.getLangMsg("typeFailureMsg").replace("${type}", type));
            return;
        }
        MonsterTypeEnum monsterTypeEnum = monsterTypeEnumOptional.get();
        Location playerLocation = player.getLocation();
        MonsterSpawnDataParam monsterSpawnParam = new MonsterSpawnDataParam();
        monsterSpawnParam.setEnable(true);
        monsterSpawnParam.setDisplayName("");
        monsterSpawnParam.setTime(60);
        monsterSpawnParam.setLastSpawnTime(System.currentTimeMillis() - 60000L);
        monsterSpawnParam.setEntityType(monsterTypeEnum.getType());
        monsterSpawnParam.setNumber(1);
        monsterSpawnParam.setMaxNumber(1);
        monsterSpawnParam.setLevel("1,30");
        monsterSpawnParam.setWorld(Objects.requireNonNull(playerLocation.getWorld()).getName());
        monsterSpawnParam.setX(playerLocation.getX());
        monsterSpawnParam.setY(playerLocation.getY());
        monsterSpawnParam.setZ(playerLocation.getZ());
        if (args.length > 2) {
            String key = args[2];
            int time = ConfigUtil.FAST_SPAWN_CONFIG.getInt(key + ".time", 60);
            int number = ConfigUtil.FAST_SPAWN_CONFIG.getInt(key + ".number", 1);
            int maxNumber = ConfigUtil.FAST_SPAWN_CONFIG.getInt(key + ".maxNumber", 1);
            String level = ConfigUtil.FAST_SPAWN_CONFIG.getString(key + ".level", "1,10");
            List drops = ConfigUtil.FAST_SPAWN_CONFIG.getStringList(key + ".drops");
            List skill = ConfigUtil.FAST_SPAWN_CONFIG.getStringList(key + ".skill");
            monsterSpawnParam.setTime(time);
            monsterSpawnParam.setLastSpawnTime(System.currentTimeMillis() - (long)time * 1000L);
            monsterSpawnParam.setNumber(number);
            monsterSpawnParam.setMaxNumber(maxNumber);
            monsterSpawnParam.setLevel(level);
            monsterSpawnParam.setDropList(drops);
            monsterSpawnParam.setSkill(skill);
        }
        String fileName = "spawn/" + monsterTypeEnum.getType().toLowerCase() + "_spawn.yml";
        String prefix = monsterTypeEnum.getType() + "_" + System.currentTimeMillis();
        YmlUtil.beanToYml(monsterSpawnParam, fileName, prefix);
        String createSpawnMsg = BaseUtil.getLangMsg("createSpawnMsg", "").replace("${monster}", monsterTypeEnum.getDesc()).replace("${fileName}", fileName);
        MessageUtil.sendMessage(sender, createSpawnMsg);
        ConfigUtil.init();
    }
}

