/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.command.admin;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.lib.command.IHandyCommandEvent;
import cn.handyplus.monster.lib.util.AssertUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.util.MonsterPlusUtil;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ItemCommand
implements IHandyCommandEvent {
    @Override
    public String command() {
        return "item";
    }

    @Override
    public String permission() {
        return "monsterPlus.item";
    }

    @Override
    public void onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        Player player;
        AssertUtil.notTrue(args.length < 2, BaseUtil.getLangMsg("paramFailureMsg"));
        if (args.length > 3) {
            player = MonsterPlusUtil.getPlayer(sender, args[3]);
            if (player == null) {
                MessageUtil.sendMessage(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
                return;
            }
        } else {
            player = AssertUtil.notPlayer(sender, BaseUtil.getMsgNotColor("noPlayerFailureMsg"));
        }
        if (!MonsterPlusConstants.ITEM_LIST.contains(args[1])) {
            MessageUtil.sendMessage(player, BaseUtil.getLangMsg("itemNo").replace("${name}", args[1]));
            return;
        }
        String[] str = args[1].split("_");
        String fileName = str[0];
        String key = str[1];
        ItemStack itemStack = MonsterPlusUtil.spawnItem(fileName, key);
        Integer number = 1;
        if (args.length > 2) {
            number = AssertUtil.isNumericToInt(args[2], BaseUtil.getLangMsg("amountFailureMsg"));
        }
        ItemStackUtil.addItem(player, itemStack, (int)number);
        String displayName = ItemStackUtil.getItemMeta(itemStack).getDisplayName();
        MessageUtil.sendMessage(player, BaseUtil.getLangMsg("itemMsg", "").replace("${name}", displayName));
    }
}

