/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.constants;

import cn.handyplus.monster.constants.EntityEquipmentTypeEnum;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.TranslationUtil;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.entity.EntityType;

public enum MonsterTypeEnum {
    ZOMBIE("ZOMBIE", "\u50f5\u5c38", EntityType.ZOMBIE, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, true, false),
    ZOMBIE_VILLAGER("ZOMBIE_VILLAGER", "\u50f5\u5c38\u6751\u6c11", EntityType.ZOMBIE_VILLAGER, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, true, false),
    HUSK("HUSK", "\u5c38\u58f3", EntityType.HUSK, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, true, false),
    DROWNED("DROWNED", "\u6eba\u5c38", EntityType.DROWNED, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_TRIDENT, true, false),
    WITHER_SKELETON("WITHER_SKELETON", "\u51cb\u96f6\u9ab7\u9ac5", EntityType.WITHER_SKELETON, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_SWORD, true, false),
    PIGLIN("PIGLIN", "\u732a\u7075", EntityType.PIGLIN, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, true, false),
    ZOMBIFIED_PIGLIN("ZOMBIFIED_PIGLIN", "\u50f5\u5c38\u732a\u7075", EntityType.ZOMBIFIED_PIGLIN, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, true, false),
    PIGLIN_BRUTE("PIGLIN_BRUTE", "\u732a\u7075\u86ee\u5175", EntityType.PIGLIN_BRUTE, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_AXE, true, false),
    SKELETON("SKELETON", "\u9ab7\u9ac5", EntityType.SKELETON, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, true, false),
    STRAY("STRAY", "\u6d41\u6d6a\u8005", EntityType.STRAY, EntityEquipmentTypeEnum.ITEM_IN_MAIN_HAND_BOW, true, false),
    SPIDER("SPIDER", "\u8718\u86db", EntityType.SPIDER, null, false, true),
    CAVE_SPIDER("CAVE_SPIDER", "\u6d1e\u7a74\u8718\u86db", EntityType.CAVE_SPIDER, null, false, true),
    OTHER("OTHER", "\u5176\u4ed6", null, null, false, false);

    private String type;
    private String desc;
    private EntityType entityType;
    private final EntityEquipmentTypeEnum equipmentTypeEnum;
    private final Boolean equipment;
    private final Boolean potionEffect;

    public static Optional<MonsterTypeEnum> getEnum(String type) {
        for (MonsterTypeEnum monsterTypeEnum : MonsterTypeEnum.values()) {
            if (!monsterTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return Optional.of(monsterTypeEnum);
        }
        Optional<EntityType> entityTypeOpt = BaseUtil.getEntityType(type);
        if (!entityTypeOpt.isPresent()) {
            return Optional.empty();
        }
        MonsterTypeEnum.OTHER.type = type;
        MonsterTypeEnum.OTHER.desc = TranslationUtil.getEntityTranslation(type);
        MonsterTypeEnum.OTHER.entityType = entityTypeOpt.get();
        return Optional.of(OTHER);
    }

    public static Optional<MonsterTypeEnum> getEnumNotOther(String type) {
        for (MonsterTypeEnum monsterTypeEnum : MonsterTypeEnum.values()) {
            if (!monsterTypeEnum.getType().equalsIgnoreCase(type)) continue;
            return Optional.of(monsterTypeEnum);
        }
        return Optional.empty();
    }

    public static MonsterTypeEnum getEnumThrow(String type) {
        Optional<MonsterTypeEnum> monsterTypeEnumOptional = MonsterTypeEnum.getEnum(type);
        if (!monsterTypeEnumOptional.isPresent()) {
            throw new RuntimeException("\u751f\u6210\u5f02\u5e38\u539f\u56e0,\u9519\u8bef\u7c7b\u578b: " + type);
        }
        return monsterTypeEnumOptional.get();
    }

    public static String getDesc(String type) {
        return MonsterTypeEnum.getEnumThrow(type).getDesc();
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public EntityType getEntityType() {
        return this.entityType;
    }

    @Generated
    public EntityEquipmentTypeEnum getEquipmentTypeEnum() {
        return this.equipmentTypeEnum;
    }

    @Generated
    public Boolean getEquipment() {
        return this.equipment;
    }

    @Generated
    public Boolean getPotionEffect() {
        return this.potionEffect;
    }

    @Generated
    private MonsterTypeEnum(String type, String desc, EntityType entityType, EntityEquipmentTypeEnum equipmentTypeEnum, Boolean equipment, Boolean potionEffect) {
        this.type = type;
        this.desc = desc;
        this.entityType = entityType;
        this.equipmentTypeEnum = equipmentTypeEnum;
        this.equipment = equipment;
        this.potionEffect = potionEffect;
    }
}

