/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.core;

import cn.handyplus.monster.constants.EntityEquipmentEnum;
import cn.handyplus.monster.constants.EntityEquipmentTypeEnum;
import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.constants.MonsterTypeEnum;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.constants.VersionCheckEnum;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.ItemMetaUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import cn.handyplus.monster.param.EntityEquipmentParam;
import cn.handyplus.monster.util.ConfigUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;

public class MonsterEquipment {
    public static void setEquipment(LivingEntity livingEntity, MonsterTypeEnum monsterTypeEnum) {
        EntityEquipmentTypeEnum equipmentTypeEnum = monsterTypeEnum.getEquipmentTypeEnum();
        if (equipmentTypeEnum == null || !monsterTypeEnum.getEquipment().booleanValue()) {
            return;
        }
        EntityEquipment equipment = livingEntity.getEquipment();
        if (equipment == null) {
            return;
        }
        EntityEquipmentParam handSwordItem = MonsterEquipment.getItemStack(equipmentTypeEnum);
        EntityEquipmentParam boots = MonsterEquipment.getItemStack(EntityEquipmentTypeEnum.BOOTS);
        EntityEquipmentParam chestPlate = MonsterEquipment.getItemStack(EntityEquipmentTypeEnum.CHEST_PLATE);
        EntityEquipmentParam helmet = MonsterEquipment.getItemStack(EntityEquipmentTypeEnum.HELMET);
        EntityEquipmentParam leggings = MonsterEquipment.getItemStack(EntityEquipmentTypeEnum.LEGGINGS);
        equipment.setItemInMainHand(handSwordItem.getItemStack());
        equipment.setBoots(boots.getItemStack());
        equipment.setChestplate(chestPlate.getItemStack());
        equipment.setHelmet(helmet.getItemStack());
        equipment.setLeggings(leggings.getItemStack());
        equipment.setHelmetDropChance(helmet.getDropChance() != false ? 1.0f : 0.0f);
        equipment.setChestplateDropChance(chestPlate.getDropChance() != false ? 1.0f : 0.0f);
        equipment.setLeggingsDropChance(leggings.getDropChance() != false ? 1.0f : 0.0f);
        equipment.setBootsDropChance(boots.getDropChance() != false ? 1.0f : 0.0f);
        equipment.setItemInMainHandDropChance(handSwordItem.getDropChance() != false ? 1.0f : 0.0f);
    }

    private static EntityEquipmentParam getItemStack(EntityEquipmentTypeEnum typeEnum) {
        EntityEquipmentParam entityEquipmentParam = EntityEquipmentEnum.getMaterial(typeEnum);
        if (entityEquipmentParam == null) {
            return EntityEquipmentParam.builder().itemStack(new ItemStack(Material.AIR)).dropChance(false).build();
        }
        String displayName = typeEnum.getName();
        List randomItemNameList = ConfigUtil.PREFIX_CONFIG.getStringList("randomItemName");
        if (CollUtil.isNotEmpty(randomItemNameList)) {
            Collections.shuffle(randomItemNameList);
            displayName = (String)randomItemNameList.get(0) + displayName;
        }
        ItemStack itemStack = new ItemStack(entityEquipmentParam.getMaterial());
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        itemMeta.setDisplayName(BaseUtil.replaceChatColor(displayName));
        MonsterEquipment.setArmorTrim(itemMeta);
        itemStack.setItemMeta(itemMeta);
        MonsterEquipment.setEnchantment(itemStack);
        entityEquipmentParam.setItemStack(itemStack);
        return entityEquipmentParam;
    }

    private static void setEnchantment(ItemStack itemStack) {
        if (itemStack == null || Material.AIR.equals((Object)itemStack.getType()) || MonsterPlusConstants.ENCHANTMENT_LOTTERY.randomIndex() != 0) {
            return;
        }
        Enchantment[] enchantments = Enchantment.values();
        for (int i = 0; i < MonsterPlusConstants.ENCHANTMENT_NUMBER; ++i) {
            int maxLevel;
            Map enchantmentsMap;
            Enchantment enchantment = enchantments[new Random().nextInt(enchantments.length)];
            if (!enchantment.canEnchantItem(itemStack) || (enchantmentsMap = itemStack.getEnchantments()).get(enchantment) != null || (maxLevel = enchantment.getMaxLevel()) < 1) continue;
            int level = new Random().nextInt(maxLevel);
            itemStack.addEnchantment(enchantment, level != 0 ? level : enchantment.getStartLevel());
        }
    }

    private static void setArmorTrim(ItemMeta itemMeta) {
        if (!BaseConstants.CONFIG.getBoolean("isTrimMaterial")) {
            return;
        }
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_20.getVersionId()) {
            return;
        }
        if (!(itemMeta instanceof ArmorMeta)) {
            return;
        }
        ArmorMeta armorMeta = (ArmorMeta)itemMeta;
        List trimMaterialList = Registry.TRIM_MATERIAL.stream().collect(Collectors.toList());
        Optional trimMaterial = trimMaterialList.stream().skip(ThreadLocalRandom.current().nextInt(trimMaterialList.size())).findFirst();
        if (!trimMaterial.isPresent()) {
            return;
        }
        List trimPatternList = Registry.TRIM_PATTERN.stream().collect(Collectors.toList());
        Optional trimPattern = trimPatternList.stream().skip(ThreadLocalRandom.current().nextInt(trimPatternList.size())).findFirst();
        if (!trimPattern.isPresent()) {
            return;
        }
        ItemMetaUtil.setTrim(armorMeta, (TrimMaterial)trimMaterial.get(), (TrimPattern)trimPattern.get());
    }
}

