/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.custom;

import cn.handyplus.monster.constants.MonsterPlusConstants;
import cn.handyplus.monster.core.MonsterDamage;
import cn.handyplus.monster.core.MonsterScoreboardTag;
import cn.handyplus.monster.event.MonsterPlusEntityDeathEvent;
import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.MapUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.ItemMetaUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.MonsterSpawnParam;
import cn.handyplus.monster.util.MonsterPlusUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class MonsterPlusEntityDeathEventListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onEvent(MonsterPlusEntityDeathEvent event) {
        List<String> dropsList = MonsterScoreboardTag.getDrops(event.getEntity());
        if (CollUtil.isEmpty(dropsList)) {
            return;
        }
        event.getDrops().clear();
        List<ItemStack> dropItemList = MonsterPlusUtil.getDropItemList(dropsList, event.getEntity().getUniqueId());
        if (CollUtil.isNotEmpty(dropItemList)) {
            boolean autoPickup = BaseConstants.CONFIG.getBoolean("autoPickup");
            Player killer = event.getEntity().getKiller();
            if (autoPickup && killer != null) {
                for (ItemStack itemStack : dropItemList) {
                    ItemStackUtil.addItem(killer, itemStack);
                }
                return;
            }
            for (ItemStack itemStack : dropItemList) {
                this.setDropHdTip(itemStack, "[NONE]");
            }
            event.getDrops().addAll(dropItemList);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onEvent1(MonsterPlusEntityDeathEvent event) {
        List<String> dropsList = MonsterScoreboardTag.getDrops(event.getEntity());
        if (CollUtil.isEmpty(dropsList)) {
            return;
        }
        Location location = event.getEntity().getLocation();
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        List<Map.Entry<String, Double>> topThreePlayers = MonsterDamage.getTopThreePlayers(event.getEntity().getUniqueId());
        Map<Integer, List<ItemStack>> topDropItemList = MonsterPlusUtil.getTopDropItemList(topThreePlayers, dropsList);
        if (MapUtil.isEmpty(topDropItemList)) {
            return;
        }
        boolean autoPickup = BaseConstants.CONFIG.getBoolean("autoPickup");
        for (int i = 0; i < 3; ++i) {
            Map.Entry<String, Double> entry = topThreePlayers.get(i);
            List<ItemStack> itemStacks = topDropItemList.get(i);
            if (autoPickup) {
                Optional<Player> onlinePlayer = BaseUtil.getOnlinePlayer(entry.getKey());
                if (!onlinePlayer.isPresent()) continue;
                for (ItemStack itemStack : itemStacks) {
                    ItemStackUtil.addItem(onlinePlayer.get(), itemStack);
                }
                continue;
            }
            OfflinePlayer offlinePlayer = BaseUtil.getOfflinePlayer(entry.getKey());
            for (ItemStack itemStack : itemStacks) {
                this.setDropHdTip(itemStack, entry.getKey());
                Item item = world.dropItemNaturally(location, itemStack);
                item.setOwner(offlinePlayer.getUniqueId());
                item.setPickupDelay(60);
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEvent2(MonsterPlusEntityDeathEvent event) {
        String monsterKey = MonsterScoreboardTag.getMonsterKey(event.getEntity());
        if (StrUtil.isEmpty(monsterKey)) {
            return;
        }
        MonsterSpawnParam monsterSpawnParam = MonsterPlusConstants.MONSTER_SPAWN_PARAM_MAP.get(monsterKey);
        if (monsterSpawnParam == null || CollUtil.isEmpty(monsterSpawnParam.getDeathMessages())) {
            return;
        }
        UUID monsterId = event.getEntity().getUniqueId();
        List<Map.Entry<String, Double>> topThreePlayers = MonsterDamage.getTopThreePlayers(monsterId);
        HashMap<String, String> variables = MapUtil.newHashMapWithExpectedSize(8);
        for (int i = 0; i < 3; ++i) {
            Map.Entry<String, Double> entry = topThreePlayers.get(i);
            String rankPrefix = MonsterDamage.getRankPrefix(i);
            variables.put(rankPrefix + "Player", "\u65e0".equals(entry.getKey()) ? "\u65e0" : entry.getKey());
            variables.put(rankPrefix + "Damage", String.format("%.2f", entry.getValue()));
        }
        variables.put("name", event.getEntity().getCustomName());
        variables.put("killer", event.getEntity().getKiller() != null ? event.getEntity().getKiller().getName() : (String)variables.get("onePlayer"));
        List<String> deathMessages = MonsterDamage.replaceVariables(monsterSpawnParam.getDeathMessages(), variables);
        MessageUtil.sendAllMessage(deathMessages);
        MonsterPlusConstants.PLAYER_DAMAGE_MAP.remove(monsterId);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onEvent3(MonsterPlusEntityDeathEvent event) {
        String monsterKey = MonsterScoreboardTag.getMonsterKey(event.getEntity());
        if (StrUtil.isEmpty(monsterKey)) {
            return;
        }
        UUID uniqueId = event.getEntity().getUniqueId();
        List<UUID> uuids = MonsterPlusConstants.MONSTER_ENTITY_MAP.get(monsterKey);
        if (CollUtil.isEmpty(uuids)) {
            return;
        }
        uuids.removeIf(uuid -> uuid.equals(uniqueId));
    }

    private void setDropHdTip(ItemStack itemStack, String playerName) {
        if (!BaseConstants.CONFIG.getBoolean("dropHdTip")) {
            return;
        }
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        ItemMetaUtil.setPersistentData(itemMeta, playerName, "dropHdTip");
        itemStack.setItemMeta(itemMeta);
    }
}

