/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.drawings;

import cn.handyplus.monster.constants.GuiTypeEnum;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.lib.core.JsonUtil;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.monster.lib.inventory.HandyInventory;
import cn.handyplus.monster.lib.inventory.HandyInventoryUtil;
import cn.handyplus.monster.lib.inventory.IHandyClickEvent;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.param.DrawingsParam;
import cn.handyplus.monster.util.ConfigUtil;
import cn.handyplus.monster.util.MonsterPlusUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class InventoryClickEventClickEvent
implements IHandyClickEvent {
    @Override
    public String guiType() {
        return GuiTypeEnum.DRAWINGS.getType();
    }

    @Override
    public void rawSlotClick(HandyInventory handyInventory, InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        Player player = handyInventory.getPlayer();
        Inventory inventory = handyInventory.getInventory();
        if (InventoryClickEventClickEvent.getSystemList().contains(rawSlot)) {
            event.setCancelled(true);
        }
        if (!HandyInventoryUtil.isIndex(rawSlot, ConfigUtil.DRAWING_CONFIG, "confirm")) {
            return;
        }
        String drawingsParamJson = handyInventory.getSearchType();
        DrawingsParam drawingsParam = JsonUtil.toBean(drawingsParamJson, DrawingsParam.class);
        Map<ItemStack, Integer> needItemList = MonsterPlusUtil.getNeedItemList(drawingsParam.getNeedList());
        HashMap<ItemStack, Integer> inventoryItemMap = new HashMap<ItemStack, Integer>();
        for (int i = 0; i < 54; ++i) {
            ItemStack item;
            if (InventoryClickEventClickEvent.getSystemList().contains(i) || (item = inventory.getItem(i)) == null || Material.AIR.equals((Object)item.getType())) continue;
            ItemStack clone = item.clone();
            clone.setAmount(1);
            for (ItemStack itemStack : needItemList.keySet()) {
                if (!ItemStackUtil.isSimilar(clone, itemStack)) continue;
                inventoryItemMap.merge(itemStack, item.getAmount(), Integer::sum);
            }
        }
        int rst = 0;
        HashMap<String, Integer> needMap = new HashMap<String, Integer>();
        for (ItemStack itemStack : needItemList.keySet()) {
            if (!inventoryItemMap.isEmpty() && inventoryItemMap.get(itemStack) != null && (Integer)inventoryItemMap.get(itemStack) >= needItemList.get(itemStack)) {
                ++rst;
                continue;
            }
            if (!inventoryItemMap.isEmpty() && inventoryItemMap.get(itemStack) != null) {
                needMap.put(BaseUtil.getDisplayName(itemStack), needItemList.get(itemStack) - (Integer)inventoryItemMap.get(itemStack));
                continue;
            }
            needMap.put(BaseUtil.getDisplayName(itemStack), needItemList.get(itemStack));
        }
        if (rst != needItemList.size()) {
            ArrayList<String> loreList = new ArrayList<String>();
            loreList.add(BaseUtil.getLangMsg("drawingsNoItem", ""));
            for (String itemName : needMap.keySet()) {
                loreList.add("&8[" + itemName + " : &f" + needMap.get(itemName) + "&8]");
            }
            ItemStack itemStack = inventory.getItem(rawSlot);
            if (itemStack != null) {
                ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
                itemMeta.setLore(BaseUtil.replaceChatColor(loreList));
                itemStack.setItemMeta(itemMeta);
            }
            return;
        }
        HandyInventoryUtil.refreshInventory(inventory);
        Map<ItemStack, Integer> drawingsItemMap = MonsterPlusUtil.getDrawingsItem(drawingsParam.getItem());
        for (ItemStack itemStack : drawingsItemMap.keySet()) {
            ItemStackUtil.addItem(player, itemStack, (int)drawingsItemMap.get(itemStack));
            MessageUtil.sendMessage(player, BaseUtil.getMsgNotColor("drawingsYesItem", "").replace("${item}", BaseUtil.getDisplayName(itemStack)));
        }
        player.closeInventory();
        if (CollUtil.isNotEmpty(drawingsParam.getCommandList())) {
            for (String command : drawingsParam.getCommandList()) {
                if (StrUtil.isEmpty(command)) continue;
                String playerCommand = StrUtil.replace(command, "player", player.getName());
                PlayerSchedulerUtil.dispatchCommand(playerCommand);
            }
        }
    }

    public static List<Integer> getSystemList() {
        String paneIndex = ConfigUtil.DRAWING_CONFIG.getString("pane.index");
        List<Integer> systemList = StrUtil.strToIntList(paneIndex);
        systemList.add(ConfigUtil.DRAWING_CONFIG.getInt("drawings.index"));
        systemList.add(ConfigUtil.DRAWING_CONFIG.getInt("confirm.index"));
        return systemList;
    }
}

