/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.drawings;

import cn.handyplus.monster.inventory.DrawingsGui;
import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

@HandyListener
public class PlayerInteractEventListener
implements Listener {
    @EventHandler
    public void onEvent(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!Action.RIGHT_CLICK_AIR.equals((Object)event.getAction()) && !Action.RIGHT_CLICK_BLOCK.equals((Object)event.getAction())) {
            return;
        }
        if (!EquipmentSlot.HAND.equals((Object)event.getHand())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || Material.AIR.equals((Object)item.getType()) || item.getItemMeta() == null || item.getAmount() > 1) {
            return;
        }
        Optional<String> drawingOpt = ItemStackUtil.getPersistentData(item, "drawings");
        if (!drawingOpt.isPresent()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack clone = item.clone();
        item.setAmount(item.getAmount() - 1);
        Inventory gui = DrawingsGui.getInstance().createGui(player, drawingOpt.get(), clone);
        player.openInventory(gui);
    }
}

