/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.item;

import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.lib.constants.BaseConstants;
import cn.handyplus.monster.lib.core.StrUtil;
import cn.handyplus.monster.lib.util.BaseUtil;
import cn.handyplus.monster.lib.util.ItemMetaUtil;
import cn.handyplus.monster.lib.util.ItemStackUtil;
import java.util.Optional;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@HandyListener
public class ItemSpawnEventListener
implements Listener {
    @EventHandler
    public void onEvent(ItemSpawnEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!BaseConstants.CONFIG.getBoolean("dropHdTip")) {
            return;
        }
        Item item = event.getEntity();
        ItemStack itemStack = item.getItemStack();
        ItemMeta itemMeta = ItemStackUtil.getItemMeta(itemStack);
        Optional<String> dropHdTip = ItemMetaUtil.getPersistentData(itemMeta, "dropHdTip");
        if (!dropHdTip.isPresent()) {
            return;
        }
        String playerName = dropHdTip.get();
        String customName = BaseUtil.getDisplayName(itemStack);
        if (itemStack.getAmount() > 1) {
            customName = customName + "\u00d7" + itemStack.getAmount();
        }
        if (StrUtil.isNotEmpty(playerName) && !"[NONE]".equals(playerName)) {
            customName = customName + " [" + playerName + "]";
        }
        item.setCustomName(customName);
        item.setCustomNameVisible(true);
        ItemMetaUtil.removePersistentData(itemMeta, "dropHdTip");
        itemStack.setItemMeta(itemMeta);
    }
}

