/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.listener.monster;

import cn.handyplus.monster.api.MonsterPlusApi;
import cn.handyplus.monster.lib.annotation.HandyListener;
import cn.handyplus.monster.lib.constants.BaseConstants;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.projectiles.ProjectileSource;

@HandyListener
public class ProjectileLaunchEventListener
implements Listener {
    @EventHandler
    public void onShoot(ProjectileLaunchEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!(event.getEntity() instanceof Arrow)) {
            return;
        }
        Arrow arrow = (Arrow)event.getEntity();
        ProjectileSource shooter = arrow.getShooter();
        if (!(shooter instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)shooter;
        int level = MonsterPlusApi.getLevel(livingEntity);
        if (level < 0) {
            return;
        }
        double levelDamage = (double)level * BaseConstants.CONFIG.getDouble("levelDamage", 0.1);
        arrow.setDamage(arrow.getDamage() + levelDamage);
    }
}

