/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.constants.SkillEnum;
import cn.handyplus.monster.lib.util.MessageUtil;
import cn.handyplus.monster.skill.AttackArrow;
import cn.handyplus.monster.skill.AttackBlitz;
import cn.handyplus.monster.skill.AttackExplosion;
import cn.handyplus.monster.skill.SpawnArrow;
import cn.handyplus.monster.skill.SpawnBerserk;
import cn.handyplus.monster.skill.SpawnPotion;
import cn.handyplus.monster.skill.SpawnTnt;
import java.util.Map;
import lombok.Generated;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class Skill {
    private Integer probability;
    private Integer delay;
    private Integer period;
    private String msg;

    public void sendMsg(Player player, String name) {
        MessageUtil.sendMessage(player, this.msg.replace("${name}", name));
    }

    public static void spawnExecution(LivingEntity livingEntity, Map<String, Object> skillMap, SkillEnum skill) {
        switch (skill) {
            case SPAWN_ARROW: {
                SpawnArrow.getInstance(skillMap).execution(livingEntity);
                break;
            }
            case SPAWN_TNT: {
                SpawnTnt.getInstance(skillMap).execution(livingEntity);
                break;
            }
            case SPAWN_BERSERK: {
                SpawnBerserk.getInstance(skillMap).execution(livingEntity);
                break;
            }
            case SPAWN_POTION: {
                SpawnPotion.getInstance(skillMap).execution(livingEntity);
                break;
            }
        }
    }

    public static void attackExecution(EntityDamageByEntityEvent event, LivingEntity livingEntity, Player player, Map<String, Object> skillMap, SkillEnum skill) {
        switch (skill) {
            case ATTACK_ARROW: {
                AttackArrow.getInstance(skillMap).execution(livingEntity, player);
                break;
            }
            case ATTACK_BLITZ: {
                AttackBlitz.getInstance(skillMap).execution(event, livingEntity, player);
                break;
            }
            case ATTACK_EXPLOSION: {
                AttackExplosion.getInstance(skillMap).execution(livingEntity, player);
                break;
            }
        }
    }

    @Generated
    public Integer getProbability() {
        return this.probability;
    }

    @Generated
    public Integer getDelay() {
        return this.delay;
    }

    @Generated
    public Integer getPeriod() {
        return this.period;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public void setProbability(Integer probability) {
        this.probability = probability;
    }

    @Generated
    public void setDelay(Integer delay) {
        this.delay = delay;
    }

    @Generated
    public void setPeriod(Integer period) {
        this.period = period;
    }

    @Generated
    public void setMsg(String msg) {
        this.msg = msg;
    }
}

