/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.monster.skill;

import cn.handyplus.monster.lib.constants.AttributeCompatEnum;
import cn.handyplus.monster.lib.core.BeanUtil;
import cn.handyplus.monster.lib.core.CollUtil;
import cn.handyplus.monster.skill.Skill;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SpawnBerserk
extends Skill {
    private Double damagePower;
    private Double healthPower;

    public static SpawnBerserk getInstance(Map<String, Object> skillMap) {
        return BeanUtil.mapToBean(SpawnBerserk.class, skillMap);
    }

    public void execution(LivingEntity livingEntity) {
        Location location;
        World world = livingEntity.getWorld();
        Collection playerCollectionList = world.getNearbyEntities(location = livingEntity.getLocation(), 30.0, 30.0, 30.0, s -> EntityType.PLAYER.equals((Object)s.getType()));
        if (CollUtil.isEmpty(playerCollectionList)) {
            return;
        }
        AttributeInstance healthAttribute = livingEntity.getAttribute(AttributeCompatEnum.MAX_HEALTH.resolve());
        AttributeInstance damageAttribute = livingEntity.getAttribute(AttributeCompatEnum.ATTACK_DAMAGE.resolve());
        if (healthAttribute == null || damageAttribute == null) {
            return;
        }
        String levelHealthStr = "MonsterPlus_levelHealth";
        String levelDamageStr = "MonsterPlus_levelDamage";
        for (AttributeModifier modifier : healthAttribute.getModifiers()) {
            if (!levelHealthStr.equals(modifier.getName())) continue;
            healthAttribute.removeModifier(modifier);
        }
        for (AttributeModifier modifier : damageAttribute.getModifiers()) {
            if (!levelDamageStr.equals(modifier.getName())) continue;
            damageAttribute.removeModifier(modifier);
        }
        healthAttribute.addModifier(new AttributeModifier(levelHealthStr, this.damagePower.doubleValue(), AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        damageAttribute.addModifier(new AttributeModifier(levelDamageStr, this.healthPower.doubleValue(), AttributeModifier.Operation.MULTIPLY_SCALAR_1));
        livingEntity.setHealth(healthAttribute.getValue());
        livingEntity.setMaxHealth(healthAttribute.getValue());
        for (Entity entity : playerCollectionList) {
            super.sendMsg((Player)entity, livingEntity.getCustomName());
        }
    }

    @Generated
    public Double getDamagePower() {
        return this.damagePower;
    }

    @Generated
    public Double getHealthPower() {
        return this.healthPower;
    }

    @Generated
    public void setDamagePower(Double damagePower) {
        this.damagePower = damagePower;
    }

    @Generated
    public void setHealthPower(Double healthPower) {
        this.healthPower = healthPower;
    }
}

