/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.combatlog999;

import com.yourname.combatlog999.ActionBarUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLog999
extends JavaPlugin
implements Listener {
    private static final String CONFIG_TIMER_DURATION = "combat-timer-duration";
    private static final String CONFIG_USE_CUSTOM_PUNISHMENTS = "use-custom-punishments";
    private static final String CONFIG_PUNISHMENTS = "punishments";
    private static final String CONFIG_DROP_INVENTORY = "drop-inventory-on-combat-log";
    private static final String CONFIG_PERMITTED_WORLDS = "permitted-worlds";
    private static final String CONFIG_TIMER_DISPLAY_MODE = "timer-display-mode";
    private static final String CONFIG_ACTIONBAR_FORMAT = "actionbar-format";
    private static final String CONFIG_BOSSBAR_FORMAT = "bossbar-format";
    private static final String CONFIG_BLOCKED_COMMANDS = "blocked-commands";
    private static final String CONFIG_MESSAGE_COMBAT_ENTER = "messages.enter-combat";
    private static final String CONFIG_MESSAGE_COMBAT_EXIT = "messages.exit-combat";
    private static final String CONFIG_MESSAGE_COMMAND_BLOCKED = "messages.command-blocked";
    private final Map<UUID, Integer> combatTimers = new HashMap<UUID, Integer>();
    private final Map<UUID, BossBar> bossBars = new HashMap<UUID, BossBar>();
    private final Set<UUID> exemptPlayers = new HashSet<UUID>();
    private FileConfiguration config;
    private File combatTagFile;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.validateConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.combatTagFile = new File(this.getDataFolder(), "combat-tags.dat");
        this.loadCombatTags();
        this.startTimerTask();
        this.getLogger().info("CombatLog999 has been enabled!");
    }

    public void onDisable() {
        this.saveCombatTags();
        for (BossBar bossBar : this.bossBars.values()) {
            bossBar.removeAll();
        }
        this.bossBars.clear();
        this.getLogger().info("CombatLog999 has been disabled!");
    }

    private void validateConfig() {
        boolean changed = false;
        if (!this.config.isSet(CONFIG_TIMER_DURATION)) {
            this.config.set(CONFIG_TIMER_DURATION, (Object)20);
            changed = true;
        }
        if (!this.config.isSet(CONFIG_USE_CUSTOM_PUNISHMENTS)) {
            this.config.set(CONFIG_USE_CUSTOM_PUNISHMENTS, (Object)true);
            changed = true;
        }
        if (!this.config.isSet(CONFIG_PUNISHMENTS)) {
            this.config.set(CONFIG_PUNISHMENTS, Collections.singletonList("kill %player%"));
            changed = true;
        }
        if (!this.config.isSet(CONFIG_DROP_INVENTORY)) {
            this.config.set(CONFIG_DROP_INVENTORY, (Object)true);
            changed = true;
        }
        if (!this.config.isSet(CONFIG_PERMITTED_WORLDS)) {
            this.config.set(CONFIG_PERMITTED_WORLDS, Arrays.asList("world", "world_nether", "world_the_end"));
            changed = true;
        }
        if (!this.config.isSet(CONFIG_TIMER_DISPLAY_MODE)) {
            this.config.set(CONFIG_TIMER_DISPLAY_MODE, (Object)"BOSS_BAR");
            changed = true;
        }
        if (!this.config.isSet(CONFIG_ACTIONBAR_FORMAT)) {
            this.config.set(CONFIG_ACTIONBAR_FORMAT, (Object)"&eCombat: &6%time% &eseconds remaining");
            changed = true;
        }
        if (!this.config.isSet(CONFIG_BOSSBAR_FORMAT)) {
            this.config.set(CONFIG_BOSSBAR_FORMAT, (Object)"&eCombat: &6%time% &eseconds remaining");
            changed = true;
        }
        if (!this.config.isSet(CONFIG_BLOCKED_COMMANDS)) {
            this.config.set(CONFIG_BLOCKED_COMMANDS, Arrays.asList("home", "spawn", "tpa", "tpahere", "tpaall"));
            changed = true;
        }
        if (!this.config.isSet(CONFIG_MESSAGE_COMBAT_ENTER)) {
            this.config.set(CONFIG_MESSAGE_COMBAT_ENTER, (Object)"&cYou entered combat! Stay for %time% seconds.");
            changed = true;
        }
        if (!this.config.isSet(CONFIG_MESSAGE_COMBAT_EXIT)) {
            this.config.set(CONFIG_MESSAGE_COMBAT_EXIT, (Object)"&aCombat timer expired. You may now leave safely.");
            changed = true;
        }
        if (!this.config.isSet(CONFIG_MESSAGE_COMMAND_BLOCKED)) {
            this.config.set(CONFIG_MESSAGE_COMMAND_BLOCKED, (Object)"&cYou cannot use that command while in combat!");
            changed = true;
        }
        if (changed) {
            this.saveConfig();
            this.reloadConfig();
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("combatlog")) {
            if (!sender.hasPermission("combatlog999.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this command!");
                return true;
            }
            if (args.length == 1) {
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target != null) {
                    boolean wasExempt = this.exemptPlayers.contains(target.getUniqueId());
                    this.setExempt(target, !wasExempt);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + "'s combat exemption: " + (wasExempt ? "REMOVED" : "GRANTED"));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                }
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /combatlog <player>");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("combatlogreload")) {
            if (!sender.hasPermission("combatlog999.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this command!");
                return true;
            }
            this.reloadConfig();
            this.config = this.getConfig();
            this.validateConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CombatLog999 config reloaded!");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Player attacker = (Player)event.getDamager();
        if (this.exemptPlayers.contains(victim.getUniqueId()) || this.exemptPlayers.contains(attacker.getUniqueId())) {
            return;
        }
        if (!this.isWorldPermitted(victim.getWorld().getName())) {
            return;
        }
        this.startCombat(victim);
        this.startCombat(attacker);
    }

    private void startCombat(Player player) {
        int duration = this.config.getInt(CONFIG_TIMER_DURATION, 20);
        boolean wasInCombat = this.isInCombat(player);
        this.combatTimers.put(player.getUniqueId(), duration);
        if (!wasInCombat) {
            String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(CONFIG_MESSAGE_COMBAT_ENTER, "&cYou entered combat! Stay for %time% seconds.")).replace("%time%", String.valueOf(duration));
            player.sendMessage(msg);
            if (this.getDisplayMode().equals("BOSS_BAR")) {
                BossBar bossBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                bossBar.addPlayer(player);
                this.bossBars.put(player.getUniqueId(), bossBar);
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handleCombatViolation(event.getPlayer());
        BossBar bossBar = this.bossBars.remove(event.getPlayer().getUniqueId());
        if (bossBar != null) {
            bossBar.removeAll();
        }
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.isInCombat(player) && !this.isWorldPermitted(event.getTo().getWorld().getName())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot teleport to that world while in combat!");
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.isInCombat(player)) {
            String command = event.getMessage().split(" ")[0].toLowerCase().substring(1);
            List blockedCommands = this.config.getStringList(CONFIG_BLOCKED_COMMANDS);
            if (blockedCommands.stream().anyMatch(command::equalsIgnoreCase)) {
                event.setCancelled(true);
                String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(CONFIG_MESSAGE_COMMAND_BLOCKED, "&cYou cannot use that command while in combat!"));
                player.sendMessage(msg);
            }
        }
    }

    private void handleCombatViolation(Player player) {
        if (this.isInCombat(player)) {
            if (this.config.getBoolean(CONFIG_USE_CUSTOM_PUNISHMENTS, true)) {
                List commands = this.config.getStringList(CONFIG_PUNISHMENTS);
                for (String command : commands) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
                }
            } else if (this.config.getBoolean(CONFIG_DROP_INVENTORY, true)) {
                Stream.of(player.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> player.getWorld().dropItemNaturally(player.getLocation(), item));
                player.getInventory().clear();
            }
            this.combatTimers.remove(player.getUniqueId());
        }
    }

    private void startTimerTask() {
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, Integer>> it = CombatLog999.this.combatTimers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, Integer> entry = it.next();
                    Player player = Bukkit.getPlayer((UUID)entry.getKey());
                    if (player == null || !player.isOnline()) {
                        it.remove();
                        BossBar bossBar = CombatLog999.this.bossBars.remove(entry.getKey());
                        if (bossBar == null) continue;
                        bossBar.removeAll();
                        continue;
                    }
                    int remaining = entry.getValue() - 1;
                    if (remaining <= 0) {
                        it.remove();
                        String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)CombatLog999.this.config.getString(CombatLog999.CONFIG_MESSAGE_COMBAT_EXIT, "&aCombat timer expired. You may now leave safely."));
                        player.sendMessage(msg);
                        BossBar bossBar = CombatLog999.this.bossBars.remove(entry.getKey());
                        if (bossBar == null) continue;
                        bossBar.removeAll();
                        continue;
                    }
                    entry.setValue(remaining);
                    CombatLog999.this.updateTimerDisplay(player, remaining);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void updateTimerDisplay(Player player, int remaining) {
        String displayMode = this.getDisplayMode();
        if (displayMode.equals("NONE")) {
            return;
        }
        if (displayMode.equals("BOSS_BAR")) {
            BossBar bossBar = this.bossBars.get(player.getUniqueId());
            if (bossBar != null) {
                String bossBarFormat = this.config.getString(CONFIG_BOSSBAR_FORMAT, "&eCombat: &6%time% &eseconds remaining");
                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)bossBarFormat.replace("%time%", String.valueOf(remaining)));
                bossBar.setTitle(title);
                double progress = (double)remaining / (double)this.config.getInt(CONFIG_TIMER_DURATION, 20);
                bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
            }
        } else if (displayMode.equals("ACTION_BAR")) {
            String actionBarFormat = this.config.getString(CONFIG_ACTIONBAR_FORMAT, "&eCombat: &6%time% &eseconds remaining");
            String message = ChatColor.translateAlternateColorCodes((char)'&', (String)actionBarFormat.replace("%time%", String.valueOf(remaining)));
            ActionBarUtil.sendActionBar(player, message);
        }
    }

    private String getDisplayMode() {
        return this.config.getString(CONFIG_TIMER_DISPLAY_MODE, "BOSS_BAR").toUpperCase();
    }

    private boolean isInCombat(Player player) {
        return this.combatTimers.containsKey(player.getUniqueId());
    }

    private boolean isWorldPermitted(String worldName) {
        List worlds = this.config.getStringList(CONFIG_PERMITTED_WORLDS);
        return worlds.isEmpty() || worlds.contains(worldName);
    }

    public void setExempt(Player player, boolean exempt) {
        if (exempt) {
            this.exemptPlayers.add(player.getUniqueId());
        } else {
            this.exemptPlayers.remove(player.getUniqueId());
        }
    }

    private void saveCombatTags() {
        try {
            if (!this.combatTagFile.exists()) {
                if (!this.combatTagFile.getParentFile().exists()) {
                    this.combatTagFile.getParentFile().mkdirs();
                }
                this.combatTagFile.createNewFile();
            }
            Properties props = new Properties();
            for (Map.Entry<UUID, Integer> entry : this.combatTimers.entrySet()) {
                props.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
            try (FileOutputStream fos = new FileOutputStream(this.combatTagFile);){
                props.store(fos, "CombatLog999 Combat Timers");
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to save combat tag data: " + e.getMessage());
        }
    }

    private void loadCombatTags() {
        if (!this.combatTagFile.exists()) {
            return;
        }
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(this.combatTagFile);){
                props.load(fis);
            }
            for (String key : props.stringPropertyNames()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    int time = Integer.parseInt(props.getProperty(key));
                    Player player = Bukkit.getPlayer((UUID)uuid);
                    if (player == null || !player.isOnline()) continue;
                    this.startCombat(player);
                    this.combatTimers.put(uuid, time);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (!this.combatTagFile.delete()) {
                this.getLogger().warning("Could not delete combat tag data file after loading.");
            }
        }
        catch (IOException e) {
            this.getLogger().severe("Failed to load combat tag data: " + e.getMessage());
        }
    }
}

