/*
 * Decompiled with CFR 0.152.
 */
package com.yourname.combatlog999;

import com.yourname.combatlog999.ActionBarUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CombatLog999
extends JavaPlugin
implements Listener {
    private static final String CONFIG_TIMER_DURATION = "combat-timer-duration";
    private static final String CONFIG_DROP_INVENTORY = "drop-inventory-on-combat-log";
    private static final String CONFIG_PERMITTED_WORLDS = "permitted-worlds";
    private static final String CONFIG_ACTIONBAR_ENABLED = "actionbar-enabled";
    private static final String CONFIG_MESSAGE_COMBAT_ENTER = "messages.enter-combat";
    private static final String CONFIG_MESSAGE_COMBAT_EXIT = "messages.exit-combat";
    private final Map<UUID, Integer> combatTimers = new HashMap<UUID, Integer>();
    private final Set<UUID> exemptPlayers = new HashSet<UUID>();
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.startTimerTask();
        this.getLogger().info("CombatLog999 has been enabled!");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("combatlog")) {
            if (!sender.hasPermission("combatlog999.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this command!");
                return true;
            }
            if (args.length == 1) {
                Player target = Bukkit.getPlayer((String)args[0]);
                if (target != null) {
                    boolean wasExempt = this.exemptPlayers.contains(target.getUniqueId());
                    this.setExempt(target, !wasExempt);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + "'s combat exemption: " + (wasExempt ? "REMOVED" : "GRANTED"));
                } else {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
                }
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /combatlog <player>");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("combatlogreload")) {
            if (!sender.hasPermission("combatlog999.admin")) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission for this command!");
                return true;
            }
            this.reloadConfig();
            this.config = this.getConfig();
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "CombatLog999 config reloaded!");
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerHit(EntityDamageByEntityEvent event) {
        if (!(event.getEntity() instanceof Player) || !(event.getDamager() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Player attacker = (Player)event.getDamager();
        if (this.exemptPlayers.contains(victim.getUniqueId()) || this.exemptPlayers.contains(attacker.getUniqueId())) {
            return;
        }
        if (!this.isWorldPermitted(victim.getWorld().getName())) {
            return;
        }
        if (!this.isInCombat(victim)) {
            this.startCombat(victim);
        }
        if (!this.isInCombat(attacker)) {
            this.startCombat(attacker);
        }
    }

    private void startCombat(Player player) {
        int duration = this.config.getInt(CONFIG_TIMER_DURATION, 20);
        this.combatTimers.put(player.getUniqueId(), duration);
        String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString(CONFIG_MESSAGE_COMBAT_ENTER, "&cYou entered combat! Stay for %time% seconds.")).replace("%time%", String.valueOf(duration));
        player.sendMessage(msg);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.handleCombatViolation(event.getPlayer());
    }

    @EventHandler
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        if (this.isInCombat(player) && !this.isWorldPermitted(event.getTo().getWorld().getName())) {
            this.handleCombatViolation(player);
        }
    }

    private void handleCombatViolation(Player player) {
        if (this.isInCombat(player)) {
            if (this.config.getBoolean(CONFIG_DROP_INVENTORY, true)) {
                player.getWorld().dropItemNaturally(player.getLocation(), player.getInventory().getItemInMainHand());
                player.getInventory().clear();
            }
            this.combatTimers.remove(player.getUniqueId());
        }
    }

    private void startTimerTask() {
        new BukkitRunnable(){

            public void run() {
                Iterator<Map.Entry<UUID, Integer>> it = CombatLog999.this.combatTimers.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<UUID, Integer> entry = it.next();
                    Player player = Bukkit.getPlayer((UUID)entry.getKey());
                    if (player == null || !player.isOnline()) {
                        it.remove();
                        continue;
                    }
                    int remaining = entry.getValue() - 1;
                    if (remaining <= 0) {
                        it.remove();
                        String msg = ChatColor.translateAlternateColorCodes((char)'&', (String)CombatLog999.this.config.getString(CombatLog999.CONFIG_MESSAGE_COMBAT_EXIT, "&aCombat timer expired. You may now leave safely."));
                        player.sendMessage(msg);
                        continue;
                    }
                    entry.setValue(remaining);
                    if (!CombatLog999.this.config.getBoolean(CombatLog999.CONFIG_ACTIONBAR_ENABLED, true)) continue;
                    ActionBarUtil.sendActionBar(player, ChatColor.translateAlternateColorCodes((char)'&', (String)CombatLog999.this.config.getString("actionbar-format", "&eCombat: &6%time% &eseconds remaining").replace("%time%", String.valueOf(remaining))));
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private boolean isInCombat(Player player) {
        return this.combatTimers.containsKey(player.getUniqueId());
    }

    private boolean isWorldPermitted(String worldName) {
        List worlds = this.config.getStringList(CONFIG_PERMITTED_WORLDS);
        return worlds.isEmpty() || worlds.contains(worldName);
    }

    public void setExempt(Player player, boolean exempt) {
        if (exempt) {
            this.exemptPlayers.add(player.getUniqueId());
        } else {
            this.exemptPlayers.remove(player.getUniqueId());
        }
    }
}

