/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.blocker;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import org.bukkit.Bukkit;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PunchEnchantBlocker
implements Listener {
    private final UltimatePVP plugin;

    public PunchEnchantBlocker(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        boolean allowPunch = this.plugin.getConfig().getBoolean("allow-punch", false);
        if (allowPunch) {
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || !item.getType().toString().contains("BOW")) {
            return;
        }
        if (event.getEnchantsToAdd().containsKey(Enchantment.ARROW_KNOCKBACK)) {
            event.getEnchantsToAdd().remove(Enchantment.ARROW_KNOCKBACK);
            if (event.getEnchanter() instanceof Player) {
                Player player = event.getEnchanter();
                player.sendMessage("\u00a7cPunch ist deaktiviert!");
            }
        }
    }

    @EventHandler
    public void onPrepareAnvil(PrepareAnvilEvent event) {
        boolean allowPunch = this.plugin.getConfig().getBoolean("allow-punch", false);
        if (allowPunch) {
            return;
        }
        AnvilInventory inv = event.getInventory();
        ItemStack first = inv.getItem(0);
        ItemStack second = inv.getItem(1);
        if (first == null || second == null) {
            return;
        }
        if (!first.getType().toString().contains("BOW")) {
            return;
        }
        if (second.containsEnchantment(Enchantment.ARROW_KNOCKBACK)) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void onAnvilClick(InventoryClickEvent event) {
        boolean allowPunch = this.plugin.getConfig().getBoolean("allow-punch", false);
        if (allowPunch) {
            return;
        }
        if (event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        if (event.getRawSlot() != 2) {
            return;
        }
        ItemStack result = event.getCurrentItem();
        if (result == null || !result.getType().toString().contains("BOW")) {
            return;
        }
        if (result.containsEnchantment(Enchantment.ARROW_KNOCKBACK)) {
            event.setCancelled(true);
            HumanEntity humanEntity = event.getWhoClicked();
            if (humanEntity instanceof Player) {
                Player player = (Player)humanEntity;
                player.sendMessage("\u00a7cPunch ist deaktiviert!");
            }
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

