/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.blocker;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.plugin.Plugin;

public class TotemBlocker
implements Listener {
    private final UltimatePVP plugin;

    public TotemBlocker(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent e) {
        if (!this.plugin.getConfig().getBoolean("NoTotems", true)) {
            return;
        }
        Entity entity = e.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player p = (Player)entity;
        if (p.getHealth() - e.getFinalDamage() <= 0.0) {
            if (p.getInventory().getItemInOffHand().getType() == Material.TOTEM_OF_UNDYING) {
                p.getInventory().setItemInOffHand(null);
                p.sendMessage("\u00a7cTotems deaktiviert!");
            } else if (p.getInventory().getItemInMainHand().getType() == Material.TOTEM_OF_UNDYING) {
                p.getInventory().setItemInMainHand(null);
                p.sendMessage("\u00a7cTotems deaktiviert!");
            }
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent e) {
        if (!this.plugin.getConfig().getBoolean("NoTotems", true)) {
            return;
        }
        if (!(e.getEntity() instanceof Player)) {
            return;
        }
        Item item = e.getItem();
        if (item.getItemStack().getType() == Material.TOTEM_OF_UNDYING) {
            e.setCancelled(true);
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

