/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.commands;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DuelCommand
implements CommandExecutor,
TabCompleter {
    private final UltimatePVP plugin;

    public DuelCommand(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender s, Command cmd, String lbl, String[] a) {
        if (!(s instanceof Player)) {
            Msg.send(s, "&cOnly ingame.");
            return true;
        }
        Player p = (Player)s;
        if (a.length == 0) {
            Msg.send((CommandSender)p, "&7Nutze: &e/duel <Spieler> &7| &e/duel accept &7| &e/duel cancel");
            return true;
        }
        String sub = a[0].toLowerCase(Locale.ROOT);
        if (sub.equals("accept")) {
            this.plugin.duels().accept(p);
            return true;
        }
        if (sub.equals("cancel")) {
            this.plugin.duels().cancel(p);
            return true;
        }
        Player target = Bukkit.getPlayer((String)a[0]);
        if (target == null) {
            Msg.send((CommandSender)p, "&cPlayer not found.");
            return true;
        }
        this.plugin.duels().request(p, target);
        return true;
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] a) {
        ArrayList<String> out = new ArrayList<String>();
        if (s instanceof Player) {
            Player p = (Player)s;
            if (a.length == 1) {
                boolean hasReq = this.plugin.duels().hasPendingRequest(p.getUniqueId());
                if (hasReq) {
                    if ("accept".startsWith(a[0].toLowerCase())) {
                        out.add("accept");
                    }
                    if ("cancel".startsWith(a[0].toLowerCase())) {
                        out.add("cancel");
                    }
                    return out;
                }
                String q = a[0].toLowerCase();
                for (Player pl : Bukkit.getOnlinePlayers()) {
                    if (pl.equals((Object)p) || !pl.getName().toLowerCase().startsWith(q)) continue;
                    out.add(pl.getName());
                }
            }
        }
        return out;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

