/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.commands;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LinkedHeartCommand
implements CommandExecutor {
    private final UltimatePVP plugin;

    public LinkedHeartCommand(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            Msg.send(sender, this.plugin.getLangManager().get("linked_heart_only_ingame"));
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.isLinkedHeartEnabled()) {
            Msg.send((CommandSender)player, this.plugin.getLangManager().get("linked_heart_disabled"));
            return true;
        }
        UUID self = player.getUniqueId();
        int lives = this.plugin.lives().getLives(self);
        if (lives > 0) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("lives", String.valueOf(lives));
            Msg.send((CommandSender)player, this.plugin.getLangManager().get("linked_heart_lives_remaining", placeholders));
            return true;
        }
        UUID partner = this.plugin.linkedHearts().getPartner(self);
        if (partner == null) {
            Msg.send((CommandSender)player, this.plugin.getLangManager().get("linked_heart_not_active"));
            return true;
        }
        OfflinePlayer offlinePartner = Bukkit.getOfflinePlayer((UUID)partner);
        String partnerName = offlinePartner != null && offlinePartner.getName() != null ? offlinePartner.getName() : partner.toString();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("partner", partnerName);
        Msg.send((CommandSender)player, this.plugin.getLangManager().get("linked_heart_partner", placeholders));
        return true;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

