/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.commands;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.manager.SettingsManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class SettingsCommand
implements CommandExecutor {
    private final UltimatePVP plugin;

    public SettingsCommand(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only player can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length < 2) {
            player.sendMessage("Use: /settings armorlockgui true|false");
            return true;
        }
        if (args[0].equalsIgnoreCase("armorlockgui")) {
            boolean enabled = Boolean.parseBoolean(args[1]);
            SettingsManager sm = this.plugin.settingsManager();
            sm.setArmorLock(player.getUniqueId(), enabled);
            player.sendMessage("ArmorLock-Texturepack " + (enabled ? "active" : "deactive"));
            return true;
        }
        return false;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

