/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.commands;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import de.scholle.ultimatepvp.utils.TextureGlyphs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UltimatePVPCommand
implements CommandExecutor,
TabCompleter {
    private final UltimatePVP plugin;

    public UltimatePVPCommand(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    private void adminLog(CommandSender actor, String usedCmd, String details) {
        try {
            if (this.plugin.discord() != null) {
                String name = actor != null ? actor.getName() : "console";
                this.plugin.discord().adminCommand(name, usedCmd, details == null ? "" : details);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String sub;
        if (args.length == 0) {
            Msg.send(sender, "&cUse: /ultimatepvp <addlive|removelive|setlives|checklives|revive|linkedheart|nametags|countdown|reload>");
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("ultimatpvp.admin")) {
                    Msg.send(sender, "&cYou do not have the permissions.");
                    return true;
                }
                try {
                    this.plugin.reloadConfig();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    TextureGlyphs.loadFromConfig((Plugin)this.plugin);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                int r = 0;
                try {
                    r = this.plugin.randomTeleportRadius();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Msg.send(sender, "&aConfig reloaded. &7Actuel RTP-Radius: &e" + r + " &7Blocks.");
                return true;
            }
            case "countdown": {
                if (args.length < 2) {
                    Msg.send(sender, "&c/ultimatepvp countdown <start [seconds]|stop>");
                    return true;
                }
                String act = args[1].toLowerCase();
                if (act.equals("start")) {
                    int seconds = 120;
                    if (args.length >= 3) {
                        try {
                            seconds = Math.max(5, Integer.parseInt(args[2]));
                        }
                        catch (NumberFormatException ignored) {
                            Msg.send(sender, "&7Uncorrect number, use default: &e120s");
                        }
                    }
                    this.plugin.countdown().start(seconds);
                    Msg.send(sender, "&aCountdown startet (&f" + seconds + "s&a).");
                } else if (act.equals("stop")) {
                    this.plugin.countdown().stop();
                    Msg.send(sender, "&cCountdown stoppt.");
                } else {
                    Msg.send(sender, "&c/ultimatepvp countdown <start [seconds]|stop>");
                }
                return true;
            }
            case "addlive": {
                int addAmount;
                if (args.length != 3) {
                    Msg.send(sender, "&c/ultimatepvp addlive <Spieler> <Anzahl>");
                    return true;
                }
                Player targetAdd = Bukkit.getPlayer((String)args[1]);
                if (targetAdd == null) {
                    Msg.send(sender, "&cPlayer not found!");
                    return true;
                }
                try {
                    addAmount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUncorrect number!");
                    return true;
                }
                int currentAdd = this.plugin.lives().getLives(targetAdd.getUniqueId());
                this.plugin.lives().setLives(targetAdd.getUniqueId(), currentAdd + addAmount);
                Msg.send(sender, "&a" + targetAdd.getName() + " has " + addAmount + " Hearts received.");
                return true;
            }
            case "removelive": {
                int remAmount;
                if (args.length != 3) {
                    Msg.send(sender, "&c/ultimatepvp removelive <Spieler> <Anzahl>");
                    return true;
                }
                Player targetRem = Bukkit.getPlayer((String)args[1]);
                if (targetRem == null) {
                    Msg.send(sender, "&cPlayer not found!");
                    return true;
                }
                try {
                    remAmount = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUncorrect number!");
                    return true;
                }
                int currentRem = this.plugin.lives().getLives(targetRem.getUniqueId());
                int setRem = Math.max(0, currentRem - remAmount);
                this.plugin.lives().setLives(targetRem.getUniqueId(), setRem);
                Msg.send(sender, "&a" + targetRem.getName() + " has " + remAmount + " Hearts losed.");
                return true;
            }
            case "setlives": {
                int value;
                if (args.length != 3) {
                    Msg.send(sender, "&c/ultimatepvp setlives <Spieler> <Anzahl>");
                    return true;
                }
                Player targetSet = Bukkit.getPlayer((String)args[1]);
                if (targetSet == null) {
                    Msg.send(sender, "&cPlayer not found!");
                    return true;
                }
                try {
                    value = Integer.parseInt(args[2]);
                }
                catch (NumberFormatException e) {
                    Msg.send(sender, "&cUncorrect number!");
                    return true;
                }
                this.plugin.lives().setLives(targetSet.getUniqueId(), value);
                Msg.send(sender, "&a" + targetSet.getName() + " has now " + value + " Hearts.");
                return true;
            }
            case "checklives": 
            case "check": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/ultimatepvp checklives <Spieler>");
                    return true;
                }
                Player targetCheck = Bukkit.getPlayer((String)args[1]);
                if (targetCheck == null) {
                    Msg.send(sender, "&cPlayer not found!");
                    return true;
                }
                int lives = this.plugin.lives().getLives(targetCheck.getUniqueId());
                Msg.send(sender, "&a" + targetCheck.getName() + " has &f" + lives + " &aHearts.");
                return true;
            }
            case "linkedheart": {
                if (!this.plugin.isLinkedHeartEnabled()) {
                    Msg.send(sender, "&cLinkedHeart is currently not enabled.");
                    return true;
                }
                if (args.length < 2) {
                    Msg.send(sender, "&c/ultimatepvp linkedheart <start|check|<PlayerA> <PlayerB>>");
                    return true;
                }
                String lsub = args[1].toLowerCase();
                if (lsub.equals("start")) {
                    String mode = this.plugin.getConfig().getString("generate", "random").toLowerCase();
                    if (!mode.equals("random")) {
                        Msg.send(sender, "&cLinkedHearts only can generated automatically if generate is enabled in the config!");
                        return true;
                    }
                    this.plugin.linkedHearts().linkAllOnlineRandomly();
                    Msg.send(sender, "&aAll Online-Player are linked now.");
                    return true;
                }
                if (lsub.equals("check")) {
                    String name;
                    if (args.length != 3) {
                        Msg.send(sender, "&c/criticalpvp linkedheart check <Player>");
                        return true;
                    }
                    Player t = Bukkit.getPlayer((String)args[2]);
                    if (t == null) {
                        Msg.send(sender, "&cPlayer not found!");
                        return true;
                    }
                    UUID partner = this.plugin.linkedHearts().getPartner(t.getUniqueId());
                    String string = name = partner != null ? Bukkit.getOfflinePlayer((UUID)partner).getName() : null;
                    Msg.send(sender, (String)(partner != null ? "&aPartner: &f" + String.valueOf(name != null ? name : partner) : "&cNo partner set."));
                    return true;
                }
                if (args.length == 3) {
                    Player a = Bukkit.getPlayer((String)args[1]);
                    Player b = Bukkit.getPlayer((String)args[2]);
                    if (a == null || b == null) {
                        Msg.send(sender, "&cBoth players must be online!");
                        return true;
                    }
                    UUID aId = a.getUniqueId();
                    UUID bId = b.getUniqueId();
                    UUID oldA = this.plugin.linkedHearts().getPartner(aId);
                    UUID oldB = this.plugin.linkedHearts().getPartner(bId);
                    this.plugin.linkedHearts().startLink(aId, bId);
                    if (oldA != null && oldA != bId) {
                        this.plugin.linkedHearts().startLink(oldA, oldB != null ? oldB : oldA);
                    }
                    if (oldB != null && oldB != aId) {
                        this.plugin.linkedHearts().startLink(oldB, oldA != null ? oldA : oldB);
                    }
                    this.plugin.linkedHearts().saveNow();
                    Msg.send(sender, "&a" + a.getName() + " &7and &a" + b.getName() + " &7have been manually linked.");
                    return true;
                }
                Msg.send(sender, "&c/criticalpvp linkedheart <start|check|<PlayerA> <PlayerB>>");
                return true;
            }
            case "revive": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/criticalpvp revive <Player>");
                    return true;
                }
                OfflinePlayer off = Bukkit.getOfflinePlayer((String)args[1]);
                if (off == null || off.getName() == null && !off.hasPlayedBefore()) {
                    Msg.send(sender, "&cPlayer not found!");
                    return true;
                }
                int startLives = this.plugin.getConfig().getInt("startingLives", 3);
                this.plugin.lives().setLives(off.getUniqueId(), startLives);
                Player online = off.getPlayer();
                if (online != null) {
                    try {
                        this.plugin.spectatorBypass().clear(online);
                    }
                    catch (Throwable bId) {
                        // empty catch block
                    }
                    Msg.send((CommandSender)online, "&aYou have been revived by an admin (&f" + startLives + " &ahearts)!");
                } else if (off.getName() != null) {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("pardon " + off.getName()));
                }
                Msg.send(sender, "&a" + String.valueOf(off.getName() != null ? off.getName() : off.getUniqueId()) + " has been revived (&f" + startLives + " &ahearts).");
                return true;
            }
            case "nametags": {
                if (args.length != 2) {
                    Msg.send(sender, "&c/criticalpvp nametags <on|off>");
                    return true;
                }
                String state = args[1].toLowerCase();
                if (state.equals("on")) {
                    this.plugin.nametags().enable();
                    Msg.send(sender, "&aNametags have been enabled. &7(OPs see everything anyway)");
                } else if (state.equals("off")) {
                    this.plugin.nametags().disable();
                    Msg.send(sender, "&cNametags have been disabled. &7(Only OPs see names via hologram)");
                } else {
                    Msg.send(sender, "&c/criticalpvp nametags <on|off>");
                }
                return true;
            }
        }
        Msg.send(sender, "&cUnknown subcommand!");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        ArrayList<String> out = new ArrayList<String>();
        if (args.length == 1) {
            out.add("addlive");
            out.add("removelive");
            out.add("setlives");
            out.add("checklives");
            out.add("linkedheart");
            out.add("revive");
            out.add("nametags");
            out.add("countdown");
            out.add("reload");
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "addlive": 
                case "removelive": 
                case "setlives": 
                case "checklives": 
                case "check": 
                case "revive": {
                    this.addOnlinePlayers(out);
                    break;
                }
                case "linkedheart": {
                    out.add("start");
                    out.add("check");
                    break;
                }
                case "nametags": {
                    out.add("on");
                    out.add("off");
                }
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("linkedheart") && !args[1].equalsIgnoreCase("start") && !args[1].equalsIgnoreCase("check")) {
            this.addOnlinePlayers(out);
        }
        return out;
    }

    private void addOnlinePlayers(List<String> out) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            out.add(p.getName());
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

