/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.external.FancyNPC;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import java.lang.reflect.Method;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public final class FancyNpcBridge {
    private static Class<?> clsFancyPlugin;
    private static Class<?> clsNpcManager;
    private static Class<?> clsNpc;
    private static Class<?> clsNpcData;
    private static boolean resolved;
    private static boolean available;

    private FancyNpcBridge() {
    }

    private static void resolve() {
        if (resolved) {
            return;
        }
        try {
            clsFancyPlugin = Class.forName("de.oliver.fancynpcs.api.FancyNpcsPlugin");
            clsNpcManager = Class.forName("de.oliver.fancynpcs.api.npc.NpcManager");
            clsNpc = Class.forName("de.oliver.fancynpcs.api.npc.Npc");
            clsNpcData = Class.forName("de.oliver.fancynpcs.api.npc.NpcData");
            available = true;
        }
        catch (Throwable ignored) {
            available = false;
        }
        resolved = true;
    }

    public static boolean isAvailable() {
        FancyNpcBridge.resolve();
        return available;
    }

    public static Object createNpcData(UUID uuid, String name, Location loc) throws Exception {
        FancyNpcBridge.resolve();
        if (!available) {
            return null;
        }
        Method mCreate = clsNpcData.getMethod("create", UUID.class, String.class, Location.class);
        Object data = mCreate.invoke(null, uuid, name, loc);
        return data;
    }

    public static void setSkinFromPlayer(Object npcData, UUID playerUuid, Object player) {
        if (npcData == null) {
            return;
        }
        try {
            Method m1 = npcData.getClass().getMethod("setSkinFromPlayer", UUID.class);
            m1.invoke(npcData, playerUuid);
        }
        catch (Throwable t) {
            try {
                if (player != null) {
                    Method m2 = npcData.getClass().getMethod("setSkinFromPlayer", player.getClass());
                    m2.invoke(npcData, player);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Object createNpc(Object npcData) throws Exception {
        FancyNpcBridge.resolve();
        if (!available) {
            return null;
        }
        Object plugin = clsFancyPlugin.getMethod("get", new Class[0]).invoke(null, new Object[0]);
        Object manager = clsFancyPlugin.getMethod("getNpcManager", new Class[0]).invoke(plugin, new Object[0]);
        Method mCreateNpc = clsNpcManager.getMethod("createNpc", clsNpcData);
        return mCreateNpc.invoke(manager, npcData);
    }

    public static void createAndSpawn(Object npc) {
        if (npc == null) {
            return;
        }
        try {
            npc.getClass().getMethod("create", new Class[0]).invoke(npc, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            npc.getClass().getMethod("spawn", new Class[0]).invoke(npc, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLookAtPlayer(Object npc, boolean enable) {
        if (npc == null) {
            return;
        }
        try {
            npc.getClass().getMethod("setLookAtPlayer", Boolean.TYPE).invoke(npc, enable);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDisplayName(Object npc, Component c) {
        if (npc == null) {
            return;
        }
        try {
            npc.getClass().getMethod("setDisplayName", Component.class).invoke(npc, c);
        }
        catch (Throwable t) {
            try {
                npc.getClass().getMethod("setName", String.class).invoke(npc, c != null ? c.toString() : "");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static Location getLocation(Object npc) {
        if (npc == null) {
            return null;
        }
        try {
            Object loc = npc.getClass().getMethod("getLocation", new Class[0]).invoke(npc, new Object[0]);
            if (loc instanceof Location) {
                Location l = (Location)loc;
                return l;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static void despawnAndDelete(Object npc) {
        if (npc == null) {
            return;
        }
        try {
            npc.getClass().getMethod("despawn", new Class[0]).invoke(npc, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            npc.getClass().getMethod("delete", new Class[0]).invoke(npc, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static UUID getUuid(Object npc) {
        if (npc == null) {
            return null;
        }
        try {
            Object u = npc.getClass().getMethod("getUuid", new Class[0]).invoke(npc, new Object[0]);
            if (u instanceof UUID) {
                UUID uuid = (UUID)u;
                return uuid;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    static {
        resolved = false;
        available = false;
    }
}

