/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.external.FancyNPC;

import de.oliver.fancynpcs.api.actions.ActionTrigger;
import de.oliver.fancynpcs.api.events.NpcInteractEvent;
import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class FancyNpcListener
implements Listener {
    private final UltimatePVP plugin;

    public FancyNpcListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onNpcInteract(NpcInteractEvent e) {
        if (e.getInteractionType() != ActionTrigger.LEFT_CLICK) {
            return;
        }
        Player damager = e.getPlayer();
        if (damager == null) {
            return;
        }
        e.setCancelled(true);
        try {
            this.plugin.dummies().onNpcLeftClick(e.getNpc(), damager);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

