/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.external.InstaLeafDecay;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.external.InstaLeafDecay.TaxicabDistanceService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;

public class BlockBreakEventListener
implements Listener {
    private final ArrayList<BlockFace> neighbours = new ArrayList<BlockFace>(List.of(BlockFace.values()));

    public BlockBreakEventListener() {
        this.neighbours.remove(BlockFace.SELF);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (Tag.LEAVES.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, this.isValidLeaf(block), block);
        }
        if (Tag.LOGS.isTagged((Keyed)block.getType())) {
            this.breakLeaf(block, false, block);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onLeavesDecay(LeavesDecayEvent event) {
        this.breakLeaf(event.getBlock(), this.isValidLeaf(event.getBlock(), event.getBlock()), event.getBlock());
    }

    private void breakLeaf(Block block, boolean breakFirstBlock, Block originalBlock) {
        if (breakFirstBlock) {
            block.breakNaturally();
        }
        for (BlockFace neighbour : this.neighbours) {
            Block neighbourBlock = block.getRelative(neighbour);
            if (!this.isValidLeaf(neighbourBlock, originalBlock)) continue;
            this.breakLeaf(neighbourBlock, true, block);
        }
    }

    private boolean isValidLeaf(Block block, Block originalBlock) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Leaves)) {
            return false;
        }
        Leaves leafBlock = (Leaves)blockData;
        if (leafBlock.getDistance() < 7) {
            return false;
        }
        if (leafBlock.isPersistent()) {
            return false;
        }
        return TaxicabDistanceService.distance(block, originalBlock) < 35;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    private boolean isValidLeaf(Block block) {
        return this.isValidLeaf(block, block);
    }
}

