/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.gui;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ReviveGUI
implements Listener {
    private final UltimatePVP plugin;

    public ReviveGUI(UltimatePVP plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player opener, Player deadPlayer) {
        ReviveHolder holder = new ReviveHolder(opener.getUniqueId(), deadPlayer.getUniqueId());
        Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)27, (Component)Msg.comp("&b&lRevive Men\u00fc"));
        holder.setInventory(inv);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        fm.displayName(Msg.comp(" "));
        filler.setItemMeta(fm);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        ItemStack yes = new ItemStack(Material.EMERALD);
        ItemMeta yesMeta = yes.getItemMeta();
        yesMeta.displayName(Msg.comp("&a&lSpieler wiederbeleben"));
        yesMeta.lore(List.of(Msg.comp("&7Gib &c1 &7Herz ab, um deinen Partner"), Msg.comp("&7wiederzubeleben.")));
        yes.setItemMeta(yesMeta);
        inv.setItem(11, yes);
        ItemStack no = new ItemStack(Material.BARRIER);
        ItemMeta noMeta = no.getItemMeta();
        noMeta.displayName(Msg.comp("&c&lAblehnen"));
        noMeta.lore(List.of(Msg.comp("&7Lehne die Wiederbelebung ab.")));
        no.setItemMeta(noMeta);
        inv.setItem(15, no);
        opener.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        HumanEntity human = e.getWhoClicked();
        if (!(human instanceof Player)) {
            return;
        }
        Player p = (Player)human;
        InventoryHolder holderObj = e.getInventory().getHolder();
        if (!(holderObj instanceof ReviveHolder)) {
            return;
        }
        ReviveHolder holder = (ReviveHolder)holderObj;
        if (!p.getUniqueId().equals(holder.opener)) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || !clicked.hasItemMeta()) {
            return;
        }
        String name = "";
        Component dn = clicked.getItemMeta().displayName();
        if (dn != null) {
            name = PlainTextComponentSerializer.plainText().serialize(dn).toLowerCase();
        }
        UUID openerId = holder.opener;
        UUID targetId = holder.target;
        if (name.contains("wiederbeleben")) {
            Player tOnline;
            int openerLives = this.plugin.lives().getLives(openerId);
            if (openerLives <= 1) {
                Msg.send((CommandSender)p, "&cDu hast nicht genug Herzen, um zu opfern!");
                p.closeInventory();
                return;
            }
            this.plugin.lives().setLives(openerId, openerLives - 1);
            this.plugin.lives().setLives(targetId, 0);
            this.plugin.linkedHearts().markRevivedOnce(targetId);
            OfflinePlayer offTarget = Bukkit.getOfflinePlayer((UUID)targetId);
            if (offTarget.getName() != null) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)("pardon " + offTarget.getName()));
            }
            if ((tOnline = Bukkit.getPlayer((UUID)targetId)) != null) {
                try {
                    this.plugin.spectatorBypass().stopSpectateCycle(targetId);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.plugin.spectatorBypass().clear(tOnline);
                }
                catch (Throwable ignored) {
                    try {
                        this.plugin.spectatorBypass().clearBypass(tOnline);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                tOnline.setGameMode(GameMode.SURVIVAL);
                try {
                    PlayerInventory inv = tOnline.getInventory();
                    this.clearIfMatches(inv.getItem(0), Material.COMPASS);
                    this.clearIfMatches(inv.getItem(7), Material.NETHER_STAR);
                    this.clearIfMatches(inv.getItem(8), Material.PAPER);
                    inv.setItem(0, null);
                    inv.setItem(7, null);
                    inv.setItem(8, null);
                    tOnline.updateInventory();
                }
                catch (Throwable inv) {
                    // empty catch block
                }
                Msg.send((CommandSender)tOnline, "&aYour partner revived you! (&f1 &aHeart)");
            }
            String tName = offTarget.getName() != null ? offTarget.getName() : targetId.toString();
            Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] &a" + p.getName() + " &7hat &f" + tName + " &awiederbelebt!"));
            p.closeInventory();
        } else if (name.contains("decline")) {
            Msg.send((CommandSender)p, "&7The Revive is declined.");
            p.closeInventory();
        }
    }

    private void clearIfMatches(ItemStack item, Material type) {
        if (item == null) {
            return;
        }
        if (item.getType() != type) {
            return;
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    private static final class ReviveHolder
    implements InventoryHolder {
        final UUID opener;
        final UUID target;
        private Inventory inv;

        ReviveHolder(UUID opener, UUID target) {
            this.opener = opener;
            this.target = target;
        }

        public Inventory getInventory() {
            return this.inv;
        }

        void setInventory(Inventory inv) {
            this.inv = inv;
        }
    }
}

