/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.gui;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class TeleporterGUI {
    public static final String TITLE = ChatColor.translateAlternateColorCodes((char)'&', (String)"&8\u00bb &e\u2726 &6&l\u1d18\u1d00\u0280\u1d1b\u0274\u1d07\u0280 \u1d1b\u1d07\u029f\u1d07\u1d18\u1d0f\u0280\u1d1b &e\u2726 &8\u00ab");
    public static final String ITEM_NAME_TELEPORTER = ChatColor.translateAlternateColorCodes((char)'&', (String)"&5&lTeleporter &7(Rechtsklick)");
    public static final String ITEM_NAME_DISCORD = ChatColor.translateAlternateColorCodes((char)'&', (String)"&b&lDiscord-Server &7(Rechtsklick)");
    public static final String ITEM_NAME_LOBBY = ChatColor.translateAlternateColorCodes((char)'&', (String)"&a&lZur Lobby &7(Rechtsklick)");

    private TeleporterGUI() {
    }

    public static ItemStack createCompass() {
        ItemStack it = new ItemStack(Material.COMPASS);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName(ITEM_NAME_TELEPORTER);
        it.setItemMeta(meta);
        return it;
    }

    public static ItemStack createDiscord() {
        ItemStack it = new ItemStack(Material.PAPER);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName(ITEM_NAME_DISCORD);
        it.setItemMeta(meta);
        return it;
    }

    public static ItemStack createLobby() {
        ItemStack it = new ItemStack(Material.NETHER_STAR);
        ItemMeta meta = it.getItemMeta();
        meta.setDisplayName(ITEM_NAME_LOBBY);
        it.setItemMeta(meta);
        return it;
    }

    public static void giveAllHotbarItems(Player p) {
        try {
            UltimatePVP plugin = (UltimatePVP)JavaPlugin.getPlugin(UltimatePVP.class);
            boolean lhEnabled = plugin == null || plugin.isLinkedHeartEnabled();
            p.getInventory().setItem(0, (ItemStack)(lhEnabled ? TeleporterGUI.createCompass() : null));
            p.getInventory().setItem(7, TeleporterGUI.createLobby());
            p.getInventory().setItem(8, TeleporterGUI.createDiscord());
            if (lhEnabled && p.getInventory().getHeldItemSlot() != 0) {
                p.getInventory().setHeldItemSlot(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Inventory buildFor(Player viewer, UltimatePVP plugin) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)null, (int)9, (String)TITLE);
        ItemStack filler = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta fm = filler.getItemMeta();
        fm.setDisplayName(" ");
        filler.setItemMeta(fm);
        for (int i = 0; i < inv.getSize(); ++i) {
            inv.setItem(i, filler);
        }
        if (plugin == null || !plugin.isLinkedHeartEnabled()) {
            return inv;
        }
        UUID partnerId = null;
        try {
            partnerId = plugin.linkedHearts().getPartner(viewer.getUniqueId());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (partnerId != null) {
            ItemStack head = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta meta = (SkullMeta)head.getItemMeta();
            OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)partnerId);
            meta.setOwningPlayer(off);
            meta.setDisplayName(off != null && off.getName() != null ? off.getName() : partnerId.toString());
            head.setItemMeta((ItemMeta)meta);
            inv.setItem(4, head);
        }
        return inv;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

