/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class CombatCommandBlockListener
implements Listener {
    private final UltimatePVP plugin;
    private static final String BYPASS_PERM = "heroes.combat.bypass.commands";

    public CombatCommandBlockListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onCommand(PlayerCommandPreprocessEvent e) {
        UUID id = e.getPlayer().getUniqueId();
        if (e.getPlayer().hasPermission(BYPASS_PERM)) {
            return;
        }
        try {
            if (this.plugin.combat() != null && this.plugin.combat().isInCombat(id)) {
                e.setCancelled(true);
                Msg.send((CommandSender)e.getPlayer(), "&cYou are in combat! Commands are temporarily disabled.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

