/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;

public class DeathListener
implements Listener {
    private final UltimatePVP plugin;
    private static final DateTimeFormatter TS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public DeathListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDeath(PlayerDeathEvent event) {
        UUID victimId;
        Player victim;
        block43: {
            try {
                event.deathMessage((Component)null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            victim = event.getEntity();
            victimId = victim.getUniqueId();
            try {
                if (this.plugin.duels() == null || !this.plugin.duels().consumeDuelDeath(victimId)) break block43;
                this.safeEndCombat(victimId, false);
                Player opp = null;
                try {
                    UUID oppId = this.plugin.duels().getOpponent(victimId);
                    if (oppId != null) {
                        opp = Bukkit.getPlayer((UUID)oppId);
                    }
                }
                catch (Throwable oppId) {
                    // empty catch block
                }
                if (opp != null) {
                    this.safeEndCombat(opp.getUniqueId(), false);
                }
                return;
            }
            catch (Throwable opp) {
                // empty catch block
            }
        }
        try {
            if (this.plugin.duels() != null && this.plugin.duels().isInDuel(victimId)) {
                UUID oppId;
                UUID last;
                Player killerCandidate = victim.getKiller();
                if (killerCandidate == null && this.plugin.combat() != null && (last = this.plugin.combat().getLastAttacker(victimId)) != null) {
                    killerCandidate = Bukkit.getPlayer((UUID)last);
                }
                if (killerCandidate == null && (oppId = this.plugin.duels().getOpponent(victimId)) != null) {
                    killerCandidate = Bukkit.getPlayer((UUID)oppId);
                }
                if (killerCandidate != null && this.plugin.duels().endDuelOnDeath(victim, killerCandidate)) {
                    this.safeEndCombat(victimId, false);
                    this.safeEndCombat(killerCandidate.getUniqueId(), false);
                    return;
                }
            }
        }
        catch (Throwable killerCandidate) {
            // empty catch block
        }
        Player directKiller = victim.getKiller();
        boolean victimInCombat = false;
        try {
            victimInCombat = this.plugin.combat() != null && this.plugin.combat().isInCombat(victimId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean shouldLoseHeart = false;
        String killerNameForMsg = "uncnown";
        if (victimInCombat) {
            shouldLoseHeart = true;
            UUID last2 = null;
            try {
                if (this.plugin.combat() != null) {
                    last2 = this.plugin.combat().getLastAttacker(victimId);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (last2 != null && Bukkit.getPlayer(last2) != null) {
                killerNameForMsg = Bukkit.getPlayer(last2).getName();
                this.safeEndCombat(last2, false);
            } else if (directKiller != null) {
                killerNameForMsg = directKiller.getName();
                this.safeEndCombat(directKiller.getUniqueId(), false);
            }
        } else if (directKiller != null) {
            shouldLoseHeart = true;
            killerNameForMsg = directKiller.getName();
            this.safeEndCombat(directKiller.getUniqueId(), false);
        }
        this.safeEndCombat(victimId, false);
        if (!shouldLoseHeart) {
            return;
        }
        int before = this.plugin.lives().getLives(victimId);
        int after = Math.max(0, before - 1);
        this.plugin.lives().setLives(victimId, after);
        Bukkit.getServer().broadcast(Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] &c" + victim.getName() + " &fwurde von &a" + killerNameForMsg + " &fbesiegt. &7(Leben: &f" + after + "&7)"));
        if (this.plugin.discord() != null) {
            String date = LocalDateTime.now().format(TS);
            this.plugin.discord().pvPKill(killerNameForMsg, victim.getName(), after, after == 0, date);
        }
        if (after > 0) {
            return;
        }
        boolean lhEnabled = true;
        try {
            lhEnabled = this.plugin.getConfig().getBoolean("linkedheart.enabled", true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!lhEnabled) {
            this.eliminate(victim);
            return;
        }
        if (before > 0) {
            Msg.send((CommandSender)victim, "&6\u2665 &7You have 0 heart \u2013 LinkedHeart is now aktive. Protect your Partner!");
            return;
        }
        boolean hasRevive = false;
        UUID partnerId = null;
        try {
            hasRevive = this.plugin.linkedHearts().hasReviveLeft(victimId);
            partnerId = this.plugin.linkedHearts().getPartner(victimId);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!hasRevive) {
            this.eliminate(victim);
            return;
        }
        try {
            victim.setGameMode(GameMode.SPECTATOR);
            victim.sendActionBar((Component)Component.empty());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (partnerId != null) {
            Player partner = Bukkit.getPlayer(partnerId);
            if (partner != null && partner.isOnline()) {
                try {
                    Player finalPartner = partner;
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.reviveGui().open(finalPartner, victim));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                Msg.send((CommandSender)victim, "&7Wait for your partner's decision \u2026");
            } else {
                Msg.send((CommandSender)victim, "&7Your partner can revive you once as soon as they are online.");
            }
        } else {
            this.eliminate(victim);
        }
    }

    private void eliminate(Player victim) {
        if (victim.hasPermission("helden.bypass")) {
            try {
                this.plugin.spectatorBypass().startSpectateCycle(victim);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                victim.setGameMode(GameMode.SPECTATOR);
                victim.sendActionBar((Component)Component.empty());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Msg.send((CommandSender)victim, "&cYou have been eliminated (Bypass). Spectator-Mod activated.");
        } else {
            String reason = "\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] \u00a7fYou've lost everyone's hearts and are now \u00a74ELIMINATED!";
            try {
                victim.kick((Component)Component.text((String)"\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] \u00a7fYou've lost everyone's hearts and are now \u00a74ELIMINATED!"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Date expiry = Date.from(LocalDateTime.now().plusDays(36500L).atZone(ZoneId.systemDefault()).toInstant());
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(victim.getName(), "\u00a7f[\u00a76\u00a7l\u029c\u1d07\u029f\u1d05\u1d07\u0274\u00a7f] \u00a7fYou've lost everyone's hearts and are now \u00a74ELIMINATED!", expiry, "UltimatePVPSystem");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void safeEndCombat(UUID id, boolean notify) {
        try {
            if (this.plugin.combat() != null) {
                this.plugin.combat().endCombat(id, notify);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

