/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.LangManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;

public class GameplayRestrictionsListener
implements Listener {
    private final UltimatePVP plugin;
    private final LangManager lang;
    private final Map<UUID, Long> lastWarn;

    public GameplayRestrictionsListener(UltimatePVP plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLangManager();
        this.lastWarn = new HashMap<UUID, Long>();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortal(PlayerPortalEvent e) {
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), this.lang.get("msg_nether_disabled"));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTeleport(PlayerTeleportEvent e) {
        if (e.getTo() != null && e.getTo().getWorld() != null && e.getTo().getWorld().getEnvironment() == World.Environment.NETHER) {
            e.setCancelled(true);
            this.sendOnce(e.getPlayer(), this.lang.get("msg_nether_disabled"));
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onOpenMerchant(InventoryOpenEvent e) {
        HumanEntity player = e.getPlayer();
        if (player instanceof Player) {
            Player p = (Player)player;
            if (e.getInventory().getType() == InventoryType.MERCHANT) {
                e.setCancelled(true);
                this.sendOnce(p, this.lang.get("msg_villager_trade_disabled"));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onMaceDamage(EntityDamageByEntityEvent e) {
        Projectile proj;
        ProjectileSource shooter;
        Player attacker = null;
        Entity damager = e.getDamager();
        if (damager instanceof Player) {
            Player player2;
            attacker = player2 = (Player)damager;
        } else if (damager instanceof Projectile && (shooter = (proj = (Projectile)damager).getShooter()) instanceof Player) {
            Player player;
            attacker = player = (Player)shooter;
        }
        if (attacker == null) {
            return;
        }
    }

    private void sendOnce(Player p, String msg) {
        if (p == null) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = this.lastWarn.get(p.getUniqueId());
        if (last == null || now - last >= 1000L) {
            this.lastWarn.put(p.getUniqueId(), now);
            p.sendMessage(msg);
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure function failed! Plugin will be disabled.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure could not be checked! Plugin will be disabled.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

