/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class KeepInventoryListener
implements Listener {
    private final UltimatePVP plugin;

    public KeepInventoryListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(PlayerDeathEvent e) {
        double keepPercentage;
        Player victim = e.getEntity();
        UUID id = victim.getUniqueId();
        boolean wasInCombat = this.plugin.combat().isInCombat(id);
        double d = keepPercentage = wasInCombat ? this.plugin.getConfig().getDouble("keepInventoryPercentageCombat", 0.0) : this.plugin.getConfig().getDouble("keepInventoryPercentageNatural", 0.0);
        if (keepPercentage <= 0.0) {
            return;
        }
        ArrayList<ItemStack> keptItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> droppedItems = new ArrayList<ItemStack>();
        for (ItemStack item : e.getDrops()) {
            if (item == null) continue;
            if (Math.random() < keepPercentage) {
                keptItems.add(item.clone());
                continue;
            }
            droppedItems.add(item);
        }
        e.getDrops().clear();
        e.getDrops().addAll(droppedItems);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            Player p = Bukkit.getPlayer((UUID)id);
            if (p != null && p.isOnline()) {
                for (ItemStack item : keptItems) {
                    p.getInventory().addItem(new ItemStack[]{item});
                }
                Msg.send((CommandSender)p, "&aDu hast &f" + (int)(keepPercentage * 100.0) + "% &adeiner Items behalten.");
            }
        }, 20L);
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

