/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.manager.CountdownManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;

public class SpawnScatterListener
implements Listener {
    private final UltimatePVP plugin;

    public SpawnScatterListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        try {
            if (this.plugin.spectatorBypass() != null && this.plugin.spectatorBypass().isBypassing(p.getUniqueId())) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!p.hasPlayedBefore()) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                World w = CountdownManager.mainWorld();
                Location loc = this.plugin.countdown().randomSafeLocation(w, 2500, 12);
                if (loc != null) {
                    this.plugin.countdown().teleportAndSettle(p, loc, true);
                }
            }, 5L);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent e) {
        Player p = e.getPlayer();
        try {
            if (this.plugin.spectatorBypass() != null && this.plugin.spectatorBypass().isBypassing(p.getUniqueId())) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (e.isBedSpawn() || e.isAnchorSpawn()) {
            return;
        }
        World w = CountdownManager.mainWorld();
        Location loc = this.plugin.countdown().randomSafeLocation(w, 2500, 12);
        if (loc == null) {
            return;
        }
        e.setRespawnLocation(loc);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.countdown().teleportAndSettle(p, loc, false), 1L);
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

