/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.listeners;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.gui.TeleporterGUI;
import de.scholle.ultimatepvp.utils.Msg;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class TeleporterListener
implements Listener {
    private final UltimatePVP plugin;

    public TeleporterListener(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    private boolean isTeleporterItem(ItemStack it) {
        return it != null && it.getType() == Material.COMPASS && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_TELEPORTER.equals(it.getItemMeta().getDisplayName());
    }

    private boolean isLobbyItem(ItemStack it) {
        return it != null && it.getType() == Material.NETHER_STAR && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_LOBBY.equals(it.getItemMeta().getDisplayName());
    }

    private boolean isDiscordItem(ItemStack it) {
        return it != null && it.getType() == Material.PAPER && it.hasItemMeta() && TeleporterGUI.ITEM_NAME_DISCORD.equals(it.getItemMeta().getDisplayName());
    }

    @EventHandler
    public void onUse(PlayerInteractEvent e) {
        if (e.getHand() != null && e.getHand() == EquipmentSlot.OFF_HAND) {
            return;
        }
        ItemStack inHand = e.getPlayer().getInventory().getItemInMainHand();
        if (inHand == null || !inHand.hasItemMeta()) {
            return;
        }
        if (this.isTeleporterItem(inHand)) {
            switch (e.getAction()) {
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    e.setCancelled(true);
                    if (!this.plugin.isLinkedHeartEnabled()) {
                        Msg.send((CommandSender)e.getPlayer(), "&cLinkedHeart ist derzeit deaktiviert.");
                        return;
                    }
                    e.getPlayer().openInventory(TeleporterGUI.buildFor(e.getPlayer(), this.plugin));
                }
            }
            return;
        }
        if (this.isLobbyItem(inHand)) {
            switch (e.getAction()) {
                case RIGHT_CLICK_AIR: 
                case RIGHT_CLICK_BLOCK: {
                    e.setCancelled(true);
                    try {
                        ByteArrayOutputStream b = new ByteArrayOutputStream();
                        DataOutputStream out = new DataOutputStream(b);
                        out.writeUTF("Connect");
                        out.writeUTF("lobby1");
                        e.getPlayer().sendPluginMessage((Plugin)this.plugin, "BungeeCord", b.toByteArray());
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        HumanEntity whoClicked = e.getWhoClicked();
        if (!(whoClicked instanceof Player)) {
            return;
        }
        Player p = (Player)whoClicked;
        if (e.getView() == null || e.getView().getTitle() == null || !TeleporterGUI.TITLE.equals(e.getView().getTitle())) {
            return;
        }
        e.setCancelled(true);
        if (!this.plugin.isLinkedHeartEnabled()) {
            p.closeInventory();
            return;
        }
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() != Material.PLAYER_HEAD || !clicked.hasItemMeta()) {
            return;
        }
        SkullMeta sm = (SkullMeta)clicked.getItemMeta();
        if (sm.getOwningPlayer() == null || sm.getOwningPlayer().getUniqueId() == null) {
            return;
        }
        Player target = Bukkit.getPlayer((UUID)sm.getOwningPlayer().getUniqueId());
        if (target == null || !target.isOnline()) {
            Msg.send((CommandSender)p, "&cDein Partner ist aktuell offline.");
            p.closeInventory();
            return;
        }
        p.teleportAsync(target.getLocation());
        p.closeInventory();
    }

    @EventHandler
    public void onDrag(InventoryDragEvent e) {
        if (e.getView() != null && TeleporterGUI.TITLE.equals(e.getView().getTitle())) {
            e.setCancelled(true);
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

