/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.manager;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.manager.CombatManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CobwebManager {
    private final CombatManager combatManager;
    private final int maxCobwebs;
    private final Map<UUID, Integer> placedCobwebs = new HashMap<UUID, Integer>();

    public CobwebManager(CombatManager combatManager, int maxCobwebs) {
        this.combatManager = combatManager;
        this.maxCobwebs = maxCobwebs;
    }

    public boolean canPlaceCobweb(Player player) {
        if (!this.combatManager.isInCombat(player.getUniqueId())) {
            return true;
        }
        int placed = this.placedCobwebs.getOrDefault(player.getUniqueId(), 0);
        return placed < this.maxCobwebs;
    }

    public void recordCobwebPlacement(Player player) {
        if (!this.combatManager.isInCombat(player.getUniqueId())) {
            return;
        }
        UUID uuid = player.getUniqueId();
        this.placedCobwebs.put(uuid, this.placedCobwebs.getOrDefault(uuid, 0) + 1);
    }

    public void resetCobwebs(UUID uuid) {
        this.placedCobwebs.remove(uuid);
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    public int getPlacedCobwebs(Player player) {
        return this.placedCobwebs.getOrDefault(player.getUniqueId(), 0);
    }

    public int getMaxCobwebs() {
        return this.maxCobwebs;
    }
}

