/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.manager;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DuelManager {
    private final UltimatePVP plugin;
    private final Map<UUID, UUID> pendingRequests;
    private final Map<UUID, UUID> activeDuels;
    private final Map<UUID, Integer> duelCounts;
    private final Set<UUID> duelDeathVictims;
    private final File duelFile;
    private FileConfiguration duelCfg;
    private static final int DUEL_LIMIT = 2;

    public DuelManager(UltimatePVP plugin) {
        this.plugin = plugin;
        this.pendingRequests = new HashMap<UUID, UUID>();
        this.activeDuels = new HashMap<UUID, UUID>();
        this.duelCounts = new HashMap<UUID, Integer>();
        this.duelDeathVictims = ConcurrentHashMap.newKeySet();
        this.duelFile = new File(plugin.getDataFolder(), "duels.yml");
        this.loadCounts();
    }

    public void request(Player from, Player to) {
        if (from.getUniqueId().equals(to.getUniqueId())) {
            Msg.send((CommandSender)from, "&cDu kannst dich nicht selbst herausfordern.");
            return;
        }
        if (this.isInDuel(from.getUniqueId()) || this.isInDuel(to.getUniqueId())) {
            Msg.send((CommandSender)from, "&cEiner von euch steckt bereits in einem Duell.");
            return;
        }
        if (this.duelCounts.getOrDefault(from.getUniqueId(), 0) >= 2) {
            Msg.send((CommandSender)from, "&cDu hast dein Duell-Limit (&f2&c) bereits verbraucht.");
            return;
        }
        if (this.pendingRequests.containsKey(to.getUniqueId())) {
            Msg.send((CommandSender)from, "&c" + to.getName() + " hat bereits eine offene Anfrage.");
            return;
        }
        this.pendingRequests.put(to.getUniqueId(), from.getUniqueId());
        Msg.send((CommandSender)from, "&aDu hast &f" + to.getName() + " &aherausgefordert!");
        Msg.send((CommandSender)to, "&f" + from.getName() + " &ahat dich zu einem &6Duell &aherausgefordert!");
        Msg.send((CommandSender)to, "&7Nimm an mit &e/duel accept&7, lehne ab mit &e/duel cancel&7.");
    }

    public void accept(Player acceptor) {
        UUID target = acceptor.getUniqueId();
        UUID requester = this.pendingRequests.get(target);
        if (requester == null) {
            Msg.send((CommandSender)acceptor, "&cDu hast aktuell keine offene Duell-Anfrage.");
            return;
        }
        Player req = Bukkit.getPlayer((UUID)requester);
        if (req == null || !req.isOnline()) {
            this.pendingRequests.remove(target);
            Msg.send((CommandSender)acceptor, "&cDer Herausforderer ist nicht mehr online.");
            return;
        }
        this.pendingRequests.remove(target);
        this.startDuel(req, acceptor);
    }

    public void cancel(Player targetPlayer) {
        UUID target = targetPlayer.getUniqueId();
        UUID requester = this.pendingRequests.remove(target);
        if (requester == null) {
            Msg.send((CommandSender)targetPlayer, "&cDu hast keine offene Duell-Anfrage.");
            return;
        }
        OfflinePlayer req = Bukkit.getOfflinePlayer((UUID)requester);
        Msg.send((CommandSender)targetPlayer, "&7Du hast die Duell-Anfrage von &f" + String.valueOf(req.getName() != null ? req.getName() : requester) + " &7abgelehnt.");
        if (req.isOnline()) {
            Msg.send((CommandSender)req.getPlayer(), "&c" + targetPlayer.getName() + " &7hat deine Duell-Anfrage abgelehnt.");
        }
    }

    public boolean endDuelOnDeath(Player victim, Player killer) {
        if (killer == null) {
            return false;
        }
        UUID v = victim.getUniqueId();
        UUID k = killer.getUniqueId();
        if (!this.isInDuel(v) || !this.isInDuel(k)) {
            return false;
        }
        if (!Objects.equals(this.getOpponent(v), k)) {
            return false;
        }
        Bukkit.broadcast((Component)Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] (Duell) &a" + killer.getName() + " &fhat &c" + victim.getName() + " &fbesiegt!"));
        this.stopDuel(v, k);
        this.duelDeathVictims.add(v);
        return true;
    }

    public boolean consumeDuelDeath(UUID victim) {
        return this.duelDeathVictims.remove(victim);
    }

    public void forceEndIfInDuel(Player p, String reason) {
        UUID a = p.getUniqueId();
        if (!this.isInDuel(a)) {
            return;
        }
        UUID b = this.getOpponent(a);
        Player other = Bukkit.getPlayer((UUID)b);
        this.stopDuel(a, b);
        if (other != null && other.isOnline()) {
            Msg.send((CommandSender)other, "&7Dein Duell wurde beendet: &f" + p.getName() + " &7(" + reason + ")");
        }
    }

    public boolean isInDuel(UUID id) {
        return this.activeDuels.containsKey(id);
    }

    public UUID getOpponent(UUID id) {
        return this.activeDuels.get(id);
    }

    public boolean hasPendingRequest(UUID playerId) {
        return this.pendingRequests.containsKey(playerId);
    }

    private void startDuel(Player a, Player b) {
        this.activeDuels.put(a.getUniqueId(), b.getUniqueId());
        this.activeDuels.put(b.getUniqueId(), a.getUniqueId());
        this.duelCounts.put(a.getUniqueId(), this.duelCounts.getOrDefault(a.getUniqueId(), 0) + 1);
        this.saveCounts();
        Bukkit.broadcast((Component)Msg.comp("&f[&6&l\u029c\u1d07\u029f\u1d05\u1d07\u0274&f] &aDuell gestartet: &f" + a.getName() + " &7vs. &f" + b.getName()));
        Msg.send((CommandSender)a, "&7Du bist nun im Duell mit &f" + b.getName() + "&7. (Kein Herzverlust)");
        Msg.send((CommandSender)b, "&7Du bist nun im Duell mit &f" + a.getName() + "&7. (Kein Herzverlust)");
    }

    private void stopDuel(UUID a, UUID b) {
        this.activeDuels.remove(a);
        this.activeDuels.remove(b);
    }

    private void loadCounts() {
        try {
            if (!this.duelFile.exists()) {
                this.duelFile.getParentFile().mkdirs();
                this.duelFile.createNewFile();
            }
            this.duelCfg = YamlConfiguration.loadConfiguration((File)this.duelFile);
            if (this.duelCfg.isConfigurationSection("counts")) {
                for (String key : this.duelCfg.getConfigurationSection("counts").getKeys(false)) {
                    try {
                        UUID id = UUID.fromString(key);
                        int c = this.duelCfg.getInt("counts." + key, 0);
                        this.duelCounts.put(id, c);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Konnte duels.yml nicht laden: " + e.getMessage());
        }
    }

    private void saveCounts() {
        if (this.duelCfg == null) {
            this.duelCfg = new YamlConfiguration();
        }
        this.duelCfg.set("counts", null);
        for (Map.Entry<UUID, Integer> en : this.duelCounts.entrySet()) {
            this.duelCfg.set("counts." + en.getKey().toString(), (Object)en.getValue());
        }
        try {
            this.duelCfg.save(this.duelFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Konnte duels.yml nicht speichern: " + e.getMessage());
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

