/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.manager;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import de.scholle.ultimatepvp.utils.TextureGlyphs;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class HeartsService {
    private final UltimatePVP plugin;
    private BukkitTask task;

    public HeartsService(UltimatePVP plugin) {
        this.plugin = plugin;
    }

    public void startTicker() {
        this.stopTicker();
        this.task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (Player p : Bukkit.getOnlinePlayers()) {
                UUID id = p.getUniqueId();
                if (this.plugin.combat() != null && this.plugin.combat().isInCombat(id)) continue;
                if (this.plugin.spectatorBypass().isBypassing(id)) {
                    p.sendActionBar((Component)Component.empty());
                    continue;
                }
                int lives = this.plugin.lives().getLives(id);
                if (lives > 0) {
                    p.sendActionBar((Component)Component.text((String)TextureGlyphs.heartsBar(lives)));
                    continue;
                }
                UUID partnerId = this.plugin.linkedHearts().getPartner(id);
                if (partnerId != null) {
                    OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)partnerId);
                    String partnerName = off != null && off.getName() != null ? off.getName() : "Partner";
                    String line = "&6" + TextureGlyphs.linkedIcon() + " &7| &7&l" + partnerName;
                    p.sendActionBar(Msg.comp(line));
                    continue;
                }
                String line2 = "&6" + TextureGlyphs.linkedIcon() + " &7| &7&lNicht Aktiv";
                p.sendActionBar(Msg.comp(line2));
            }
        }, 20L, 40L);
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    public void stopTicker() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }
}

