/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.manager;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class NametagManager {
    private static final String TEAM_NAME = "helden_nt";
    private static final String HOLO_TAG = "helden_nt_holo";
    private final UltimatePVP plugin;
    private boolean enabled = true;
    private Team team;

    public NametagManager(UltimatePVP plugin) {
        this.plugin = plugin;
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            this.setupScoreboardTeam();
            this.cleanupLeftoverHolos();
        });
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.setTeamVisibility(Team.OptionStatus.ALWAYS);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.setTeamVisibility(Team.OptionStatus.NEVER);
    }

    public void handleJoin(Player p) {
        this.addToTeam(p);
    }

    public void handleQuit(Player p) {
    }

    public void handleWorldChange(Player p) {
    }

    public void reapplyAllOnline() {
        this.setupScoreboardTeam();
        this.setTeamVisibility(this.enabled ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.addToTeam(p);
        }
        this.cleanupLeftoverHolos();
    }

    private void setupScoreboardTeam() {
        if (Bukkit.getScoreboardManager() == null) {
            this.plugin.getLogger().warning("ScoreboardManager nicht verf\u00fcgbar. Team-Setup \u00fcbersprungen.");
            return;
        }
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Team t = sb.getTeam(TEAM_NAME);
        if (t == null) {
            t = sb.registerNewTeam(TEAM_NAME);
        }
        this.team = t;
        try {
            this.team.setOption(Team.Option.NAME_TAG_VISIBILITY, this.enabled ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER);
            this.team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.ALWAYS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.addToTeam(p);
        }
    }

    private void addToTeam(Player p) {
        String entry;
        if (this.team == null) {
            this.setupScoreboardTeam();
            if (this.team == null) {
                return;
            }
        }
        if (!this.team.hasEntry(entry = p.getName())) {
            this.team.addEntry(entry);
        }
    }

    private void setTeamVisibility(Team.OptionStatus status) {
        if (this.team == null) {
            this.setupScoreboardTeam();
            if (this.team == null) {
                return;
            }
        }
        try {
            this.team.setOption(Team.Option.NAME_TAG_VISIBILITY, status);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void cleanupLeftoverHolos() {
        for (World w : Bukkit.getWorlds()) {
            for (Entity e : w.getEntitiesByClass(ArmorStand.class)) {
                if (!e.getScoreboardTags().contains(HOLO_TAG)) continue;
                try {
                    e.remove();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

