/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.manager;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.gui.TeleporterGUI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class SpectatorBypassManager {
    private final UltimatePVP plugin;
    private final Set<UUID> bypassing;
    private Team eliminatedTeam;
    private final Map<UUID, BukkitTask> cycleTasks;
    private final Map<UUID, Integer> cycleIndex;
    private final NamespacedKey BYPASS_FLAG;

    public SpectatorBypassManager(UltimatePVP plugin) {
        this.plugin = plugin;
        this.bypassing = ConcurrentHashMap.newKeySet();
        this.cycleTasks = new HashMap<UUID, BukkitTask>();
        this.cycleIndex = new HashMap<UUID, Integer>();
        this.BYPASS_FLAG = new NamespacedKey((Plugin)plugin, "bypass_eliminated");
        Bukkit.getScheduler().runTask((Plugin)plugin, this::setupTeam);
    }

    private void setupTeam() {
        Scoreboard sb = Bukkit.getScoreboardManager().getMainScoreboard();
        Team t = sb.getTeam("eliminated");
        if (t == null) {
            t = sb.registerNewTeam("eliminated");
        }
        t.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        this.eliminatedTeam = t;
    }

    public boolean isBypassing(UUID id) {
        return this.bypassing.contains(id);
    }

    public boolean isBypassSpectator(UUID id) {
        return this.isBypassing(id);
    }

    public Set<UUID> all() {
        return Collections.unmodifiableSet(this.bypassing);
    }

    public boolean hasBypassFlag(Player p) {
        try {
            Byte v = (Byte)p.getPersistentDataContainer().get(this.BYPASS_FLAG, PersistentDataType.BYTE);
            return v != null && v == 1;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public void apply(Player p) {
        UUID id = p.getUniqueId();
        if (!this.bypassing.add(id)) {
            try {
                p.getPersistentDataContainer().set(this.BYPASS_FLAG, PersistentDataType.BYTE, (Object)1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.hideFromAll(p);
            return;
        }
        try {
            p.getPersistentDataContainer().set(this.BYPASS_FLAG, PersistentDataType.BYTE, (Object)1);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.eliminatedTeam != null && p.getName() != null) {
            this.eliminatedTeam.addEntry(p.getName());
        }
        p.setAllowFlight(true);
        p.setFlying(true);
        p.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 0, false, false, false));
        try {
            p.setInvisible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            p.setGlowing(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (p.getGameMode() == GameMode.SPECTATOR) {
            p.setGameMode(GameMode.SURVIVAL);
        }
        this.hideFromAll(p);
        try {
            TeleporterGUI.giveAllHotbarItems(p);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        p.sendActionBar((Component)Component.text((String)"\u00a77\u00a7lZUSCHAUER"));
    }

    public void applyBypass(Player p) {
        this.apply(p);
    }

    public void startSpectateCycle(Player p) {
        this.stopSpectateCycle(p.getUniqueId());
        this.apply(p);
        if (p.getGameMode() == GameMode.SPECTATOR) {
            p.setGameMode(GameMode.SURVIVAL);
        }
    }

    public void stopSpectateCycle(UUID id) {
        BukkitTask t = this.cycleTasks.remove(id);
        if (t != null) {
            t.cancel();
        }
        this.cycleIndex.remove(id);
    }

    public void clear(Player p) {
        UUID id = p.getUniqueId();
        this.stopSpectateCycle(id);
        if (!this.bypassing.remove(id)) {
            return;
        }
        try {
            p.getPersistentDataContainer().remove(this.BYPASS_FLAG);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.eliminatedTeam != null && p.getName() != null) {
            this.eliminatedTeam.removeEntry(p.getName());
        }
        try {
            p.setInvisible(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        p.removePotionEffect(PotionEffectType.INVISIBILITY);
        try {
            p.setGlowing(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.showToAll(p);
        if (p.getGameMode() != GameMode.SPECTATOR && p.getGameMode() != GameMode.CREATIVE) {
            p.setFlying(false);
            p.setAllowFlight(false);
        }
    }

    public void clearBypass(Player p) {
        this.clear(p);
    }

    private void hideFromAll(Player p) {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            if (viewer.equals((Object)p)) continue;
            viewer.hidePlayer((Plugin)this.plugin, p);
        }
    }

    private void showToAll(Player p) {
        for (Player viewer : Bukkit.getOnlinePlayers()) {
            if (viewer.equals((Object)p)) continue;
            viewer.showPlayer((Plugin)this.plugin, p);
        }
    }

    public void hideAllBypassersFrom(Player viewer) {
        for (UUID id : this.bypassing) {
            Player bp = Bukkit.getPlayer((UUID)id);
            if (bp == null || !bp.isOnline() || bp.equals((Object)viewer)) continue;
            viewer.hidePlayer((Plugin)this.plugin, bp);
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

