/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.storage;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class LinkedHeartStore {
    private final Plugin plugin;
    private final Map<UUID, UUID> links = new HashMap<UUID, UUID>();
    private final Set<UUID> revivedOnce = new HashSet<UUID>();
    private final File file;

    public LinkedHeartStore(Plugin plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "linkedhearts.yml");
        this.load();
    }

    public void startLink(UUID a, UUID b) {
        if (a == null || b == null || a.equals(b)) {
            return;
        }
        this.links.put(a, b);
        this.links.put(b, a);
    }

    public UUID getPartner(UUID id) {
        return this.links.get(id);
    }

    public String getPartnerName(UUID id) {
        UUID partner = this.links.get(id);
        if (partner == null) {
            return null;
        }
        OfflinePlayer off = Bukkit.getOfflinePlayer((UUID)partner);
        return off != null ? off.getName() : null;
    }

    public boolean hasReviveLeft(UUID victim) {
        return !this.revivedOnce.contains(victim);
    }

    public void markRevivedOnce(UUID victim) {
        if (victim != null) {
            this.revivedOnce.add(victim);
        }
        this.saveNow();
    }

    public void clearReviveFlag(UUID player) {
        this.revivedOnce.remove(player);
        this.saveNow();
    }

    public void linkAllOnlineRandomly() {
        ArrayList<Player> list = new ArrayList<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (p.isOp()) continue;
            list.add(p);
        }
        Collections.shuffle(list, new Random());
        this.links.clear();
        this.revivedOnce.clear();
        int i = 0;
        while (i + 1 < list.size()) {
            UUID a = ((Player)list.get(i)).getUniqueId();
            UUID b = ((Player)list.get(i + 1)).getUniqueId();
            this.startLink(a, b);
            i += 2;
        }
        this.saveNow();
    }

    public void clearAll() {
        this.links.clear();
        this.revivedOnce.clear();
        this.saveNow();
    }

    public void saveNow() {
        try {
            YamlConfiguration cfg = new YamlConfiguration();
            ArrayList<CallSite> pairs = new ArrayList<CallSite>();
            HashSet<UUID> visited = new HashSet<UUID>();
            for (Map.Entry<UUID, UUID> e : this.links.entrySet()) {
                String sb;
                UUID a = e.getKey();
                UUID b = e.getValue();
                if (b == null || visited.contains(a) || visited.contains(b)) continue;
                String sa = a.toString();
                if (sa.compareTo(sb = b.toString()) <= 0) {
                    pairs.add((CallSite)((Object)(sa + ";" + sb)));
                } else {
                    pairs.add((CallSite)((Object)(sb + ";" + sa)));
                }
                visited.add(a);
                visited.add(b);
            }
            cfg.set("pairs", pairs);
            ArrayList<String> revived = new ArrayList<String>();
            for (UUID u : this.revivedOnce) {
                revived.add(u.toString());
            }
            cfg.set("revived_once", revived);
            cfg.save(this.file);
        }
        catch (IOException ex) {
            this.plugin.getLogger().severe("[LinkedHeartStore] Konnte linkedhearts.yml nicht speichern: " + ex.getMessage());
        }
    }

    private void load() {
        List revived;
        this.links.clear();
        this.revivedOnce.clear();
        if (!this.file.exists()) {
            try {
                this.plugin.getDataFolder().mkdirs();
                this.file.createNewFile();
                this.saveNow();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("[LinkedHeartStore] Konnte Datei nicht erstellen: " + e.getMessage());
            }
            return;
        }
        YamlConfiguration cfg = YamlConfiguration.loadConfiguration((File)this.file);
        List pairs = cfg.getStringList("pairs");
        if (pairs != null) {
            for (String s : pairs) {
                String[] parts = s.split(";");
                if (parts.length != 2) continue;
                try {
                    UUID a = UUID.fromString(parts[0]);
                    UUID b = UUID.fromString(parts[1]);
                    this.startLink(a, b);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((revived = cfg.getStringList("revived_once")) != null) {
            for (String su : revived) {
                try {
                    this.revivedOnce.add(UUID.fromString(su));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

