/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.utils;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import de.scholle.ultimatepvp.utils.Msg;
import de.scholle.ultimatepvp.utils.TextureGlyphs;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class HeartsHud {
    private HeartsHud() {
    }

    public static Component forLives(int lives) {
        String bar = TextureGlyphs.heartsBar(lives);
        return Component.text((String)bar);
    }

    public static Component linked(String partnerName) {
        String name = partnerName == null || partnerName.isEmpty() ? "Noch nicht aktiv" : partnerName;
        String msg = "&6" + TextureGlyphs.linkedIcon() + " &7&l" + name;
        return Msg.comp(msg);
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

