/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import de.scholle.ultimatepvp.UltimatePVP;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;

public class LangManager {
    private final UltimatePVP plugin;
    private Map<String, String> messages;

    public LangManager(UltimatePVP plugin) {
        this.plugin = plugin;
        this.loadLang();
    }

    public void loadLang() {
        try {
            File langFile = new File(this.plugin.getDataFolder(), "lang.json");
            if (!langFile.exists()) {
                this.plugin.saveResource("lang.json", false);
            }
            FileReader reader = new FileReader(langFile);
            this.messages = (Map)new Gson().fromJson((Reader)reader, new TypeToken<Map<String, String>>(this){}.getType());
            reader.close();
            if (this.messages == null) {
                this.messages = new HashMap<String, String>();
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error by loading lang.json!");
            e.printStackTrace();
            this.messages = new HashMap<String, String>();
        }
    }

    public String get(String key) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)this.messages.getOrDefault(key, "&cMissing lang key: " + key));
    }

    public String get(String key, Map<String, String> placeholders) {
        String msg = this.get(key);
        if (placeholders != null) {
            for (Map.Entry<String, String> entry : placeholders.entrySet()) {
                msg = msg.replace("%" + entry.getKey() + "%", entry.getValue());
            }
        }
        return msg;
    }
}

