/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SkinFetcher {
    private static final HttpClient HTTP = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private static final Map<UUID, TextureProp> CACHE = new ConcurrentHashMap<UUID, TextureProp>();

    public static TextureProp getSignedTexture(UUID uuid) {
        TextureProp cached = CACHE.get(uuid);
        if (cached != null) {
            return cached;
        }
        try {
            String undashed = uuid.toString().replace("-", "");
            URI uri = URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + undashed + "?unsigned=false");
            HttpRequest req = HttpRequest.newBuilder(uri).timeout(Duration.ofSeconds(8L)).header("Accept", "application/json").GET().build();
            HttpResponse<String> resp = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
            if (resp.statusCode() != 200) {
                return null;
            }
            JsonObject obj = JsonParser.parseString((String)resp.body()).getAsJsonObject();
            JsonArray props = obj.getAsJsonArray("properties");
            if (props == null) {
                return null;
            }
            for (JsonElement el : props) {
                JsonObject p = el.getAsJsonObject();
                if (!"textures".equals(p.get("name").getAsString())) continue;
                String value = p.get("value").getAsString();
                String sig = p.has("signature") ? p.get("signature").getAsString() : null;
                TextureProp tp = new TextureProp(value, sig);
                CACHE.put(uuid, tp);
                return tp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }

    public record TextureProp(String value, String signature) {
    }
}

