/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.ultimatepvp.utils;

import de.scholle.ultimatepvp.Secure;
import de.scholle.ultimatepvp.UltimatePVP;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class TextureGlyphs {
    private static String HEARTS_0 = "\ue916";
    private static String HEARTS_1 = "\ue917";
    private static String HEARTS_2 = "\ue918";
    private static String HEARTS_3 = "\ue919";
    private static String LINKED_ICON = "\u2764";

    private TextureGlyphs() {
    }

    public static void loadFromConfig(Plugin plugin) {
        if (plugin == null || plugin.getConfig() == null) {
            return;
        }
        String base = "glyphs.hearts.";
        HEARTS_0 = plugin.getConfig().getString("glyphs.hearts.0", HEARTS_0);
        HEARTS_1 = plugin.getConfig().getString("glyphs.hearts.1", HEARTS_1);
        HEARTS_2 = plugin.getConfig().getString("glyphs.hearts.2", HEARTS_2);
        HEARTS_3 = plugin.getConfig().getString("glyphs.hearts.3", HEARTS_3);
        LINKED_ICON = plugin.getConfig().getString("glyphs.linked_icon", LINKED_ICON);
    }

    public static String heartsBar(int lives) {
        int v = Math.max(0, Math.min(3, lives));
        switch (v) {
            case 0: {
                return HEARTS_0;
            }
            case 1: {
                return HEARTS_1;
            }
            case 2: {
                return HEARTS_2;
            }
        }
        return HEARTS_3;
    }

    public static String linkedHeartBar(String partnerName) {
        String name = partnerName == null || partnerName.isEmpty() ? "Noch nicht aktiv" : partnerName;
        return LINKED_ICON + " " + name;
    }

    public static String linkedIcon() {
        return LINKED_ICON;
    }

    public void loadConfigChecks(UltimatePVP plugin) {
        try {
            String test = Secure.encryptString("x");
            if (!"x".equals(Secure.decryptString(test))) {
                plugin.getLogger().severe("[UltimatePVP] FATAL: Secure-Funktion fehlerhaft! Plugin wird deaktiviert.");
                Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("[UltimatePVP] FATAL: Secure konnte nicht gepr\u00fcft werden! Plugin wird deaktiviert.");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)plugin);
        }
    }
}

