/*
 * Decompiled with CFR 0.152.
 */
package refabricated.com.epherical.epherolib.lang;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2590;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;
import refabricated.com.epherical.epherolib.config.LanguageConfig;

public class ServerTranslation
extends class_2588 {
    private final class_2477 language;
    private List<class_5348> decomposedParts = ImmutableList.of();
    private static final class_5348 TEXT_PERCENT = class_5348.method_29430((String)"%");
    private static final class_5348 TEXT_NULL = class_5348.method_29430((String)"null");
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ServerTranslation(class_2477 language, String key, @Nullable String fallback, Object[] args) {
        super(key, fallback, args);
        this.language = language;
    }

    protected void decomposePieces() {
        String msg = this.field_41875 != null ? this.language.method_4679(this.method_11022(), this.field_41875) : this.language.method_48307(this.method_11022());
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            Objects.requireNonNull(builder);
            this.decomposeTemplate(msg, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.decomposedParts = builder.build();
        }
        catch (class_2590 e) {
            this.decomposedParts = ImmutableList.of((Object)class_5348.method_29430((String)msg));
        }
    }

    private void decomposeTemplate(String string, Consumer<class_5348> consumer) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string2;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string2 = string.substring(j, k);
                    if (string2.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    consumer.accept(class_5348.method_29430((String)string2));
                }
                string2 = matcher.group(2);
                String string3 = string.substring(k, l);
                if ("%".equals(string2) && "%%".equals(string3)) {
                    consumer.accept(TEXT_PERCENT);
                } else {
                    if (!"s".equals(string2)) {
                        throw new class_2590((class_2588)this, "Unsupported format: '" + string3 + "'");
                    }
                    String string4 = matcher.group(1);
                    int m = string4 != null ? Integer.parseInt(string4) - 1 : i++;
                    consumer.accept(this.argument(m));
                }
                j = l;
            }
            if (j < string.length()) {
                String string5 = string.substring(j);
                if (string5.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(class_5348.method_29430((String)string5));
            }
        }
        catch (IllegalArgumentException var12) {
            throw new class_2590((class_2588)this, (Throwable)var12);
        }
    }

    public class_5348 argument(int i) {
        if (i >= 0 && i < this.method_11023().length) {
            Object object = this.method_11023()[i];
            if (object instanceof class_2561) {
                return (class_2561)object;
            }
            return object == null ? TEXT_NULL : class_5348.method_29430((String)object.toString());
        }
        throw new class_2590((class_2588)this, i);
    }

    public <T> Optional<T> method_27660(class_5348.class_5246<T> styledContentConsumer, class_2583 style) {
        this.decomposePieces();
        Optional optional = Optional.empty();
        for (class_5348 decomposedPart : this.decomposedParts) {
            optional = decomposedPart.method_27658(styledContentConsumer, style);
        }
        return optional;
    }

    public <T> Optional<T> method_27659(class_5348.class_5245<T> contentConsumer) {
        this.decomposePieces();
        Optional optional = Optional.empty();
        for (class_5348 decomposedPart : this.decomposedParts) {
            optional = decomposedPart.method_27657(contentConsumer);
        }
        return optional;
    }

    public class_5250 method_10890(@Nullable class_2168 commandSourceStack, @Nullable class_1297 entity, int i) throws CommandSyntaxException {
        Object[] objects = new Object[this.method_11023().length];
        for (int j = 0; j < objects.length; ++j) {
            Object object = this.method_11023()[j];
            objects[j] = object instanceof class_2561 ? class_2564.method_10881((class_2168)commandSourceStack, (class_2561)((class_2561)object), (class_1297)entity, (int)i) : object;
        }
        return class_5250.method_43477((class_7417)new ServerTranslation(this.language, this.method_11022(), this.field_41875, objects));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ServerTranslation) {
            ServerTranslation contents = (ServerTranslation)((Object)object);
            return Objects.equals(this.method_11022(), contents.method_11022()) && Objects.equals(this.field_41875, contents.field_41875) && Arrays.equals(this.method_11023(), contents.method_11023());
        }
        return false;
    }

    public String toString() {
        return "Stranslation{key='" + this.method_11022() + "'" + (String)(this.field_41875 != null ? ", fallback='" + this.field_41875 + "'" : "") + ", args=" + Arrays.toString(this.method_11023()) + "}";
    }

    public static class_5250 translatable(class_3222 player, String key) {
        return class_5250.method_43477((class_7417)new ServerTranslation(LanguageConfig.getLanguage(player), key, null, class_2588.field_24367));
    }

    public static class_5250 translatable(class_3222 player, String key, Object ... args) {
        return class_5250.method_43477((class_7417)new ServerTranslation(LanguageConfig.getLanguage(player), key, null, args));
    }

    public static class_5250 translatableWithFallback(class_3222 player, String key, @Nullable String fallback) {
        return class_5250.method_43477((class_7417)new ServerTranslation(LanguageConfig.getLanguage(player), key, fallback, class_2588.field_24367));
    }

    public static class_5250 translatableWithFallback(class_3222 player, String key, @Nullable String fallback, Object ... args) {
        return class_5250.method_43477((class_7417)new ServerTranslation(LanguageConfig.getLanguage(player), key, fallback, args));
    }
}

