/*
 * Decompiled with CFR 0.152.
 */
package refabricated.com.epherical.epherolib.config;

import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.slf4j.Logger;
import refabricated.com.epherical.epherolib.CommonPlatform;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.CommentedConfigurationNode;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurateException;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.ConfigurationNode;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.loader.AbstractConfigurationLoader;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.TypeSerializer;
import refabricated.com.epherical.epherolib.libs.org.spongepowered.configurate.serialize.TypeSerializerCollection;

public abstract class CommonConfig {
    private final boolean devEnvironment = Boolean.getBoolean("epherolib.dev");
    protected int configVersion = 1;
    protected static final Logger LOGGER = LogUtils.getLogger();
    protected AbstractConfigurationLoader.Builder<?, ?> loaderBuilder;
    protected AbstractConfigurationLoader<?> loader;
    protected ConfigurationNode rootNode;
    protected final String configName;
    private TypeSerializerCollection.Builder serializers;

    public CommonConfig(AbstractConfigurationLoader.Builder<?, ?> loaderBuilder, String configName) {
        this.loaderBuilder = loaderBuilder;
        this.configName = configName;
        this.serializers = TypeSerializerCollection.builder();
    }

    public <T, V extends TypeSerializer<T>> void addSerializer(Class<T> clazz, V instance) {
        this.serializers.register(clazz, instance);
    }

    public void addSerializer(TypeSerializerCollection collection) {
        this.serializers.registerAll(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadConfig(String modID) {
        URL path;
        boolean createdFile;
        File file;
        block30: {
            file = new File(this.getConfigPath(modID).toFile(), this.configName);
            createdFile = false;
            path = null;
            if (this.devEnvironment) {
                path = this.getClass().getClassLoader().getResource(this.configName);
            } else {
                try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.configName);){
                    byte[] bytes = new byte[stream.available()];
                    stream.read(bytes);
                    LOGGER.info("Creating default config file: " + this.configName);
                    createdFile = CommonConfig.createdFile(file);
                    if (!createdFile) break block30;
                    try (FileOutputStream outputStream = new FileOutputStream(file);){
                        outputStream.write(bytes);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Could not find an internal config file for {}", (Object)this.configName);
                }
                finally {
                    try {
                        createdFile = CommonConfig.createdFile(file);
                        path = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.loader = ((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)((AbstractConfigurationLoader.Builder)this.loaderBuilder.sink(() -> new BufferedWriter(new FileWriter(file)))).defaultOptions(options -> options.serializers(builder -> builder.registerAll(this.serializers.build())))).url(path)).build();
        try {
            if (createdFile) {
                this.loader.save(this.generateConfig(CommentedConfigurationNode.root(this.loader.defaultOptions())));
            }
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
        }
        try {
            int currentConfigVersion = this.getConfigVersion();
            this.rootNode = this.loader.load();
            this.parseConfig((CommentedConfigurationNode)this.rootNode);
            int value = this.rootNode.node("version").getInt();
            if (value != currentConfigVersion) {
                LOGGER.info("Upgrading professions config from {} to {}", (Object)this.getConfigVersion(), (Object)currentConfigVersion);
                this.setConfigVersion(currentConfigVersion);
                this.loader.save(this.generateConfig(CommentedConfigurationNode.root(this.rootNode.options())));
                this.rootNode = this.loader.load();
                this.parseConfig((CommentedConfigurationNode)this.rootNode);
            }
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean canCreateFile(File file) {
        return file.exists();
    }

    public static boolean createdFile(File file) {
        try {
            if (!file.getParentFile().exists() && file.getParentFile().mkdirs()) {
                LOGGER.info("Created directory for: " + file.getParentFile().getCanonicalPath());
            }
            if (!file.exists() && file.createNewFile()) {
                return true;
            }
        }
        catch (IOException e) {
            LOGGER.warn("Error creating new config file ", (Throwable)e);
            return false;
        }
        return false;
    }

    public boolean reloadConfig() {
        try {
            this.rootNode = this.loader.load();
            this.parseConfig((CommentedConfigurationNode)this.rootNode);
            this.loader.save(this.rootNode);
            return true;
        }
        catch (ConfigurateException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Path getConfigPath(String modID) {
        return CommonPlatform.platform.getRootConfigPath(modID);
    }

    public abstract void parseConfig(CommentedConfigurationNode var1);

    public abstract CommentedConfigurationNode generateConfig(CommentedConfigurationNode var1);

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }
}

