/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.Croptopia;
import com.epherical.croptopia.datagen.DependentPathProvider;
import com.epherical.croptopia.mixin.datagen.TagProviderAccessor;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.Furnace;
import com.epherical.croptopia.register.helpers.IceCream;
import com.epherical.croptopia.register.helpers.Jam;
import com.epherical.croptopia.register.helpers.Juice;
import com.epherical.croptopia.register.helpers.Pie;
import com.epherical.croptopia.register.helpers.Seafood;
import com.epherical.croptopia.register.helpers.Smoothie;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.epherical.croptopia.register.helpers.Utensil;
import com.epherical.croptopia.util.PluralInfo;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CroptopiaIndependentItemTagProvider
extends FabricTagProvider.ItemTagProvider {
    public CroptopiaIndependentItemTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> completableFuture) {
        super(output, completableFuture, null);
        ((TagProviderAccessor)((Object)this)).setPathProvider(new DependentPathProvider(output, class_7784.class_7490.field_39367, "tags/item"));
    }

    public String method_10321() {
        return "Croptopia Independent Tags";
    }

    protected void method_10514(class_7225.class_7874 arg) {
        this.generateCrops();
        this.generateSeedsSaplings();
        this.generateOtherEnums();
        this.generateMisc();
        this.generateCNamespaceTags();
        this.populateGroupTags();
    }

    protected void generateCrops() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            this.createCategoryTag(farmlandCrop.getTagCategory().getLowerCaseName(), PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural()), farmlandCrop.method_8389(), true);
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            this.createMultiCategoryTag(treeCrop, PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural()), treeCrop.method_8389());
        }
        for (Tree tree : Tree.copy()) {
            this.createCategoryTag(tree.getTagCategory().getLowerCaseName(), PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural()), tree.method_8389());
        }
    }

    protected void generateSeedsSaplings() {
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            if (farmlandCrop == Content.CHILE_PEPPER) {
                this.createSeedSaplingTag("seeds", "chilepepper", farmlandCrop.getSeedItem());
                continue;
            }
            this.createSeedSaplingTag("seeds", farmlandCrop.getLowercaseName(), farmlandCrop.getSeedItem());
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            this.createSeedSaplingTag("saplings", treeCrop.getLowercaseName(), treeCrop.getSaplingItem());
        }
        for (Tree tree : Tree.copy()) {
            this.createSeedSaplingTag("saplings", tree.getLowercaseName(), tree.getSapling());
        }
    }

    protected void generateOtherEnums() {
        for (Seafood seafood : Seafood.copy()) {
            this.createGeneralTag(seafood.getPlural(), seafood.method_8389());
        }
        for (Furnace furnace : Furnace.copy()) {
            this.createGeneralTag(furnace.getPlural(), furnace.method_8389());
        }
        for (Juice juice : Juice.copy()) {
            this.createCategoryTag("juices", juice.name().toLowerCase() + "s", juice.method_8389());
        }
        for (Jam jam : Jam.copy()) {
            this.createCategoryTag("jams", jam.name().toLowerCase() + "s", jam.method_8389());
        }
        for (Smoothie smoothie : Smoothie.copy()) {
            this.createGeneralTag(smoothie.name().toLowerCase() + "s", smoothie.method_8389());
        }
        for (IceCream iceCream : IceCream.copy()) {
            this.createGeneralTag(iceCream.name().toLowerCase() + "s", iceCream.method_8389());
        }
        for (Pie pie : Pie.copy()) {
            this.createGeneralTag(pie.name().toLowerCase() + "s", pie.method_8389());
        }
        for (Utensil utensil : Utensil.copy()) {
            this.createGeneralTag(utensil.getPlural(), utensil.method_8389());
        }
    }

    protected void generateMisc() {
        this.createGeneralTag("almond_brittles", Content.ALMOND_BRITTLE);
        this.createGeneralTag("artichoke_dips", Content.ARTICHOKE_DIP);
        this.createGeneralTag("banana_cream_pies", Content.BANANA_CREAM_PIE);
        this.createGeneralTag("banana_nut_breads", Content.BANANA_NUT_BREAD);
        this.createGeneralTag("beef_jerkies", Content.BEEF_JERKY);
        this.createGeneralTag("beef_wellington", Content.BEEF_WELLINGTON);
        this.createGeneralTag("beers", Content.BEER);
        this.createGeneralTag("blts", Content.BLT);
        this.createGeneralTag("brownies", Content.BROWNIES);
        this.createGeneralTag("buttered_toasts", Content.BUTTERED_TOAST);
        this.createGeneralTag("butters", Content.BUTTER);
        this.createGeneralTag("caesar_salads", Content.CAESAR_SALAD);
        this.createGeneralTag("candied_nuts", Content.CANDIED_NUTS);
        this.createGeneralTag("candy_corns", Content.CANDY_CORN);
        this.createGeneralTag("cashew_chickens", Content.CASHEW_CHICKEN);
        this.createGeneralTag("cheese_cakes", Content.CHEESE_CAKE);
        this.createGeneralTag("cheese_pizzas", Content.CHEESE_PIZZA);
        this.createGeneralTag("cheeseburgers", Content.CHEESEBURGER);
        this.createGeneralTag("cheeses", Content.CHEESE);
        this.createGeneralTag("chicken_and_dumplings", Content.CHICKEN_AND_DUMPLINGS);
        this.createGeneralTag("chicken_and_noodles", Content.CHICKEN_AND_NOODLES);
        this.createGeneralTag("chicken_and_rice", Content.CHICKEN_AND_RICE);
        this.createGeneralTag("chocolate_milkshakes", Content.CHOCOLATE_MILKSHAKE);
        this.createGeneralTag("chocolates", Content.CHOCOLATE);
        this.createGeneralTag("coffees", Content.COFFEE);
        this.createGeneralTag("cornish_pasty", Content.CORNISH_PASTY);
        this.createGeneralTag("cucumber_salads", Content.CUCUMBER_SALAD);
        this.createGeneralTag("doughnuts", Content.DOUGHNUT);
        this.createGeneralTag("doughs", Content.DOUGH);
        this.createGeneralTag("egg_rolls", Content.EGG_ROLL);
        this.createGeneralTag("eton_mess", Content.ETON_MESS);
        this.createGeneralTag("figgy_pudding", Content.FIGGY_PUDDING);
        this.createGeneralTag("fish_and_chips", Content.FISH_AND_CHIPS);
        this.createGeneralTag("flour", Content.FLOUR);
        this.createGeneralTag("french_fries", Content.FRENCH_FRIES);
        this.createGeneralTag("fried_chickens", Content.FRIED_CHICKEN);
        this.createGeneralTag("fruit_salads", Content.FRUIT_SALAD);
        this.createGeneralTag("fruit_smoothies", Content.FRUIT_SMOOTHIE);
        this.createGeneralTag("grilled_cheeses", Content.GRILLED_CHEESE);
        this.createGeneralTag("ham_sandwiches", Content.HAM_SANDWICH);
        this.createGeneralTag("hamburgers", Content.HAMBURGER);
        this.createGeneralTag("kale_chips", Content.KALE_CHIPS);
        this.createGeneralTag("kale_smoothies", Content.KALE_SMOOTHIE);
        this.createGeneralTag("leafy_salads", Content.LEAFY_SALAD);
        this.createGeneralTag("leek_soups", Content.LEEK_SOUP);
        this.createGeneralTag("lemon_chickens", Content.LEMON_CHICKEN);
        this.createGeneralTag("lemonades", Content.LEMONADE);
        this.createGeneralTag("limeades", Content.LIMEADE);
        this.createGeneralTag("meads", Content.MEAD);
        this.createGeneralTag("milk_bottles", Content.MILK_BOTTLE);
        this.createGeneralTag("noodles", Content.NOODLE);
        this.createGeneralTag("nougats", Content.NOUGAT);
        this.createGeneralTag("nutty_cookies", Content.NUTTY_COOKIE);
        this.createGeneralTag("oatmeals", Content.OATMEAL);
        this.createGeneralTag("olive_oils", Content.OLIVE_OIL);
        this.createGeneralTag("onion_rings", Content.ONION_RINGS);
        this.createGeneralTag("paprika", Content.PAPRIKA);
        this.createGeneralTag("peanut_butter_and_jam", Content.PEANUT_BUTTER_AND_JAM);
        this.createGeneralTag("pepperoni", Content.PEPPERONI);
        this.createGeneralTag("pineapple_pepperoni_pizzas", Content.PINEAPPLE_PEPPERONI_PIZZA);
        this.createGeneralTag("pizzas", Content.PIZZA);
        this.createGeneralTag("pork_and_beanss", Content.PORK_AND_BEANS);
        this.createGeneralTag("pork_jerkies", Content.PORK_JERKY);
        this.createGeneralTag("potato_chips", Content.POTATO_CHIPS);
        this.createGeneralTag("protein_bars", Content.PROTEIN_BAR);
        this.createGeneralTag("pumpkin_spice_lattes", Content.PUMPKIN_SPICE_LATTE);
        this.createGeneralTag("raisin_oatmeal_cookies", Content.OATMEAL_COOKIE);
        this.createGeneralTag("ravioli", Content.RAVIOLI);
        this.createGeneralTag("roasted_nuts", Content.ROASTED_NUTS);
        this.createGeneralTag("rum_raisin_ice_creams", Content.RUM_RAISIN_ICE_CREAM);
        this.createGeneralTag("rums", Content.RUM);
        this.createGeneralTag("salsas", Content.SALSA);
        this.createGeneralTag("salt_ores", Content.SALT_ORE);
        this.createGeneralTag("saucy_chips", Content.SAUCY_CHIPS);
        this.createGeneralTag("scones", Content.SCONES);
        this.createGeneralTag("scrambled_eggs", Content.SCRAMBLED_EGGS);
        this.createGeneralTag("shepherds_pie", Content.SHEPHERDS_PIE);
        this.createGeneralTag("snicker_doodles", Content.SNICKER_DOODLE);
        this.createGeneralTag("soy_milks", Content.SOY_MILK);
        this.createGeneralTag("soy_sauces", Content.SOY_SAUCE);
        this.createGeneralTag("spaghetti_squashs", Content.SPAGHETTI_SQUASH);
        this.createGeneralTag("steamed_rices", Content.STEAMED_RICE);
        this.createGeneralTag("sticky_toffee_pudding", Content.STICKY_TOFFEE_PUDDING);
        this.createGeneralTag("supreme_pizzas", Content.SUPREME_PIZZA);
        this.createGeneralTag("sushis", Content.SUSHI);
        this.createGeneralTag("sweet_potato_friess", Content.SWEET_POTATO_FRIES);
        this.createGeneralTag("tacos", Content.TACO);
        this.createGeneralTag("tea", Content.TEA);
        this.createGeneralTag("toast_with_jam", Content.TOAST_WITH_JAM);
        this.createGeneralTag("tofu", Content.TOFU);
        this.createGeneralTag("tofu_and_dumplings", Content.TOFU_AND_DUMPLINGS);
        this.createGeneralTag("tofuburgers", Content.TOFUBURGER);
        this.createGeneralTag("tortillas", Content.TORTILLA);
        this.createGeneralTag("trail_mixes", Content.TRAIL_MIX);
        this.createGeneralTag("treacle_tarts", Content.TREACLE_TART);
        this.createGeneralTag("trifle", Content.TRIFLE);
        this.createGeneralTag("tuna_sandwiches", Content.TUNA_SANDWICH);
        this.createGeneralTag("veggie_salads", Content.VEGGIE_SALAD);
        this.createGeneralTag("wines", Content.WINE);
        this.createGeneralTag("yam_jam", Content.YAM_JAM);
        this.createGeneralTag("yoghurts", Content.YOGHURT);
        this.createGeneralTag("roasted_pumpkin_seeds", Content.ROASTED_PUMPKIN_SEEDS);
        this.createGeneralTag("roasted_sunflower_seeds", Content.ROASTED_SUNFLOWER_SEEDS);
        this.createGeneralTag("pumpkin_bars", Content.PUMPKIN_BARS);
        this.createGeneralTag("corn_breads", Content.CORN_BREAD);
        this.createGeneralTag("pumpkin_soups", Content.PUMPKIN_SOUP);
        this.createGeneralTag("meringue", Content.MERINGUE);
        this.createGeneralTag("cabbage_rolls", Content.CABBAGE_ROLL);
        this.createGeneralTag("borscht", Content.BORSCHT);
        this.createGeneralTag("goulashes", Content.GOULASH);
        this.createGeneralTag("beetroot_salads", Content.BEETROOT_SALAD);
        this.createGeneralTag("candied_kumquats", Content.CANDIED_KUMQUATS);
        this.createGeneralTag("steamed_crabs", Content.STEAMED_CRAB);
        this.createGeneralTag("sea_lettuce", Content.SEA_LETTUCE);
        this.createGeneralTag("deep_fried_shrimp", Content.DEEP_FRIED_SHRIMP);
        this.createGeneralTag("tuna_rolls", Content.TUNA_ROLL);
        this.createGeneralTag("fried_calamari", Content.FRIED_CALAMARI);
        this.createGeneralTag("crab_legs", Content.CRAB_LEGS);
        this.createGeneralTag("steamed_clams", Content.STEAMED_CLAMS);
        this.createGeneralTag("grilled_oysters", Content.GRILLED_OYSTERS);
        this.createGeneralTag("anchovy_pizzas", Content.ANCHOVY_PIZZA);
        this.createGeneralTag("mashed_potatoes", Content.MASHED_POTATOES);
        this.createGeneralTag("baked_crepes", Content.BAKED_CREPES);
        this.createGeneralTag("cinnamon_rolls", Content.CINNAMON_ROLL);
        this.createGeneralTag("croque_madame", Content.CROQUE_MADAME);
        this.createGeneralTag("croque_monsieur", Content.CROQUE_MONSIEUR);
        this.createGeneralTag("dauphine_potatoes", Content.DAUPHINE_POTATOES);
        this.createGeneralTag("fried_frog_legs", Content.FRIED_FROG_LEGS);
        this.createGeneralTag("frog_legs", Content.FROG_LEGS);
        this.createGeneralTag("ground_pork", Content.GROUND_PORK);
        this.createGeneralTag("hashed_brown", Content.HASHED_BROWN);
        this.createGeneralTag("macaron", Content.MACARON);
        this.createGeneralTag("quiche", Content.QUICHE);
        this.createGeneralTag("sausages", Content.SAUSAGE);
        this.createGeneralTag("sunny_side_eggs", Content.SUNNY_SIDE_EGGS);
        this.createGeneralTag("sweet_crepes", Content.SWEET_CREPES);
        this.createGeneralTag("the_big_breakfast", Content.THE_BIG_BREAKFAST);
        class_3495 water = this.method_27169(CroptopiaIndependentItemTagProvider.register("water_bottles"));
        class_2960 waterBottle = class_7923.field_41178.method_10221((Object)Content.WATER_BOTTLE);
        class_2960 waterBucket = class_7923.field_41178.method_10221((Object)class_1802.field_8705);
        if (waterBottle != null) {
            water.method_27064(class_3497.method_43937((class_2960)waterBottle));
        }
        if (waterBucket != null) {
            water.method_27064(class_3497.method_43937((class_2960)waterBucket));
        }
        water.method_34891(class_2960.method_60654((String)"early_buckets:wooden_water_bucket"));
        class_3495 milks = this.method_27169(CroptopiaIndependentItemTagProvider.register("milks"));
        class_2960 milkBottle = class_7923.field_41178.method_10221((Object)Content.MILK_BOTTLE);
        class_2960 soyMilk = class_7923.field_41178.method_10221((Object)Content.SOY_MILK);
        class_2960 milkBucket = class_7923.field_41178.method_10221((Object)class_1802.field_8103);
        if (milkBottle != null) {
            milks.method_27064(class_3497.method_43937((class_2960)milkBottle));
        }
        if (soyMilk != null) {
            milks.method_27064(class_3497.method_43937((class_2960)soyMilk));
        }
        if (milkBucket != null) {
            milks.method_27064(class_3497.method_43937((class_2960)milkBucket));
        }
        milks.method_34892(this.independentTag("milk_buckets"));
        class_3495 potatoes = this.method_27169(CroptopiaIndependentItemTagProvider.register("potatoes"));
        class_2960 potato = class_7923.field_41178.method_10221((Object)class_1802.field_8567);
        class_2960 sweetPotato = class_7923.field_41178.method_10221((Object)Content.SWEETPOTATO.method_8389());
        if (potato != null) {
            potatoes.method_27064(class_3497.method_43937((class_2960)potato));
        }
        if (sweetPotato != null) {
            potatoes.method_27064(class_3497.method_43937((class_2960)sweetPotato));
        }
    }

    private static class_6862<class_1792> register(String id) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Croptopia.createIdentifier(id));
    }

    private void createCategoryTag(String category, String name, class_1792 item) {
        this.createCategoryTag(category, name, item, false);
    }

    private void createCategoryTag(String category, String name, class_1792 item, boolean addCropsReference) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (itemId == null) {
            return;
        }
        String path = itemId.method_12832();
        class_6862<class_1792> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + path);
        class_2960 independentEntry = this.independentTag(category + "/" + path);
        this.method_27169(forgeFriendlyTag).method_27064(class_3497.method_43937((class_2960)itemId));
        class_3495 fabricGeneralTag = this.method_27169(CroptopiaIndependentItemTagProvider.register(name));
        fabricGeneralTag.method_27064(class_3497.method_43937((class_2960)itemId));
        fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)independentEntry));
        if (addCropsReference && !category.equals("crops")) {
            fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)this.independentTag("crops/" + path)));
        }
    }

    private void createMultiCategoryTag(TreeCrop crop, String name, class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (itemId == null) {
            return;
        }
        String path = itemId.method_12832();
        String mainCategory = crop.getTagCategory().getLowerCaseName();
        class_6862<class_1792> mainForgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(mainCategory + "/" + path);
        class_2960 mainIndependentEntry = this.independentTag(mainCategory + "/" + path);
        this.method_27169(mainForgeFriendlyTag).method_27064(class_3497.method_43937((class_2960)itemId));
        if (crop.getTagCategory() != TagCategory.CROPS) {
            class_6862<class_1792> cropsForgeFriendlyTag = CroptopiaIndependentItemTagProvider.register("crops/" + path);
            class_2960 cropsIndependentEntry = this.independentTag("crops/" + path);
            this.method_27169(cropsForgeFriendlyTag).method_27064(class_3497.method_43937((class_2960)itemId));
        }
        if (crop.getTagCategory() == TagCategory.NUTS || crop.getTagCategory() == TagCategory.FRUITS) {
            class_6862<class_1792> fruitsForgeFriendlyTag = CroptopiaIndependentItemTagProvider.register("fruits/" + path);
            class_2960 fruitsIndependentEntry = this.independentTag("fruits/" + path);
            this.method_27169(fruitsForgeFriendlyTag).method_27064(class_3497.method_43937((class_2960)itemId));
        }
        class_3495 fabricGeneralTag = this.method_27169(CroptopiaIndependentItemTagProvider.register(name));
        fabricGeneralTag.method_27064(class_3497.method_43937((class_2960)itemId));
        fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)mainIndependentEntry));
        if (crop.getTagCategory() != TagCategory.CROPS) {
            fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)this.independentTag("crops/" + path)));
        }
        if (crop.getTagCategory() == TagCategory.NUTS) {
            fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)this.independentTag("fruits/" + path)));
        }
    }

    private void createGeneralTag(String name, class_1792 item) {
        class_6862<class_1792> pluralTag = CroptopiaIndependentItemTagProvider.register(name);
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (itemId != null) {
            this.method_27169(pluralTag).method_27064(class_3497.method_43937((class_2960)itemId));
        }
    }

    private void createSeedSaplingTag(String category, String name, class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        if (itemId == null) {
            return;
        }
        Object pluralSeedName = item == Content.VANILLA.getSeedItem() ? itemId.method_12832() : itemId.method_12832() + "s";
        class_6862<class_1792> forgeFriendlyTag = CroptopiaIndependentItemTagProvider.register(category + "/" + name);
        class_2960 independentEntry = this.independentTag(category + "/" + name);
        this.method_27169(forgeFriendlyTag).method_27064(class_3497.method_43937((class_2960)itemId));
        this.method_27169(CroptopiaIndependentItemTagProvider.register(category)).method_27064(class_3497.method_43945((class_2960)independentEntry));
        class_3495 fabricGeneralTag = this.method_27169(CroptopiaIndependentItemTagProvider.register((String)pluralSeedName));
        fabricGeneralTag.method_27064(class_3497.method_43937((class_2960)itemId));
        fabricGeneralTag.method_27064(class_3497.method_43945((class_2960)independentEntry));
    }

    private class_2960 independentTag(String name) {
        return class_2960.method_60655((String)"c", (String)name);
    }

    private boolean isDataGenerationMode() {
        return System.getProperty("fabric-api.datagen") != null;
    }

    private void generateCNamespaceTags() {
        String name;
        String pluralName;
        String path;
        String category;
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            category = farmlandCrop.getTagCategory().getLowerCaseName();
            path = class_7923.field_41178.method_10221((Object)farmlandCrop.method_8389()).method_12832();
            pluralName = PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural());
            this.createCNamespaceTag(category + "/" + path, farmlandCrop.method_8389());
            if (farmlandCrop.getTagCategory() != TagCategory.CROPS) {
                this.createCNamespaceTag("crops/" + path, farmlandCrop.method_8389());
            }
            this.createCNamespaceTag(pluralName, farmlandCrop.method_8389());
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            category = treeCrop.getTagCategory().getLowerCaseName();
            path = class_7923.field_41178.method_10221((Object)treeCrop.method_8389()).method_12832();
            pluralName = PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural());
            this.createCNamespaceTag(category + "/" + path, treeCrop.method_8389());
            if (treeCrop.getTagCategory() != TagCategory.CROPS) {
                this.createCNamespaceTag("crops/" + path, treeCrop.method_8389());
            }
            if (treeCrop.getTagCategory() == TagCategory.NUTS) {
                this.createCNamespaceTag("fruits/" + path, treeCrop.method_8389());
            }
            this.createCNamespaceTag(pluralName, treeCrop.method_8389());
        }
        for (Tree tree : Tree.copy()) {
            category = tree.getTagCategory().getLowerCaseName();
            path = class_7923.field_41178.method_10221((Object)tree.method_8389()).method_12832();
            pluralName = PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural());
            this.createCNamespaceTag(category + "/" + path, tree.method_8389());
            this.createCNamespaceTag(pluralName, tree.method_8389());
        }
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            name = farmlandCrop == Content.CHILE_PEPPER ? "chilepepper" : farmlandCrop.getLowercaseName();
            this.createCNamespaceTag("seeds/" + name, farmlandCrop.getSeedItem());
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            name = treeCrop.getLowercaseName();
            this.createCNamespaceTag("saplings/" + name, treeCrop.getSaplingItem());
        }
        for (Tree tree : Tree.copy()) {
            name = tree.getLowercaseName();
            this.createCNamespaceTag("saplings/" + name, tree.getSapling());
        }
        this.generateOtherEnumsCNamespaceTags();
        this.generateMiscCNamespaceTags();
    }

    private void generateOtherEnumsCNamespaceTags() {
        String pluralName;
        for (Seafood seafood : Seafood.copy()) {
            this.createCNamespaceTag(seafood.getPlural(), seafood.method_8389());
        }
        for (Furnace furnace : Furnace.copy()) {
            this.createCNamespaceTag(furnace.getPlural(), furnace.method_8389());
        }
        for (Juice juice : Juice.copy()) {
            pluralName = juice.name().toLowerCase() + "s";
            this.createCNamespaceTag(pluralName, juice.method_8389());
            this.createCNamespaceTag("juices/" + juice.name().toLowerCase(), juice.method_8389());
        }
        for (Jam jam : Jam.copy()) {
            pluralName = jam.name().toLowerCase() + "s";
            this.createCNamespaceTag(pluralName, jam.method_8389());
            this.createCNamespaceTag("jams/" + jam.name().toLowerCase(), jam.method_8389());
        }
        for (Smoothie smoothie : Smoothie.copy()) {
            this.createCNamespaceTag(smoothie.name().toLowerCase() + "s", smoothie.method_8389());
        }
        for (IceCream iceCream : IceCream.copy()) {
            this.createCNamespaceTag(iceCream.name().toLowerCase() + "s", iceCream.method_8389());
        }
        for (Pie pie : Pie.copy()) {
            this.createCNamespaceTag(pie.name().toLowerCase() + "s", pie.method_8389());
        }
        for (Utensil utensil : Utensil.copy()) {
            this.createCNamespaceTag(utensil.getPlural(), utensil.method_8389());
        }
    }

    private void generateMiscCNamespaceTags() {
        this.createCNamespaceTag("almond_brittles", Content.ALMOND_BRITTLE);
        this.createCNamespaceTag("artichoke_dips", Content.ARTICHOKE_DIP);
        this.createCNamespaceTag("banana_cream_pies", Content.BANANA_CREAM_PIE);
        this.createCNamespaceTag("banana_nut_breads", Content.BANANA_NUT_BREAD);
        this.createCNamespaceTag("beef_jerkies", Content.BEEF_JERKY);
        this.createCNamespaceTag("beef_wellington", Content.BEEF_WELLINGTON);
        this.createCNamespaceTag("beers", Content.BEER);
        this.createCNamespaceTag("blts", Content.BLT);
        this.createCNamespaceTag("brownies", Content.BROWNIES);
        this.createCNamespaceTag("buttered_toasts", Content.BUTTERED_TOAST);
        this.createCNamespaceTag("butters", Content.BUTTER);
        this.createCNamespaceTag("caesar_salads", Content.CAESAR_SALAD);
        this.createCNamespaceTag("candied_nuts", Content.CANDIED_NUTS);
        this.createCNamespaceTag("candy_corns", Content.CANDY_CORN);
        this.createCNamespaceTag("cashew_chickens", Content.CASHEW_CHICKEN);
        this.createCNamespaceTag("cheese_cakes", Content.CHEESE_CAKE);
        this.createCNamespaceTag("cheese_pizzas", Content.CHEESE_PIZZA);
        this.createCNamespaceTag("cheeseburgers", Content.CHEESEBURGER);
        this.createCNamespaceTag("cheeses", Content.CHEESE);
        this.createCNamespaceTag("chicken_and_dumplings", Content.CHICKEN_AND_DUMPLINGS);
        this.createCNamespaceTag("chicken_and_noodles", Content.CHICKEN_AND_NOODLES);
        this.createCNamespaceTag("chicken_and_rice", Content.CHICKEN_AND_RICE);
    }

    private void createCNamespaceTag(String name, class_1792 item) {
        String path;
        Object pluralName;
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        class_6862 cTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)name));
        class_3495 builder = this.method_27169(cTag);
        boolean isPluralTag = false;
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            pluralName = PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural());
            if (!name.equals(pluralName) || farmlandCrop.method_8389() != item) continue;
            isPluralTag = true;
            break;
        }
        if (!isPluralTag) {
            for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
                pluralName = PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural());
                if (!name.equals(pluralName) || treeCrop.method_8389() != item) continue;
                isPluralTag = true;
                break;
            }
        }
        if (!isPluralTag) {
            for (Tree tree : Tree.copy()) {
                pluralName = PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural());
                if (!name.equals(pluralName) || tree.method_8389() != item) continue;
                isPluralTag = true;
                break;
            }
        }
        if (!isPluralTag) {
            for (Juice juice : Juice.copy()) {
                pluralName = juice.name().toLowerCase() + "s";
                if (!name.equals(pluralName) || juice.method_8389() != item) continue;
                isPluralTag = true;
                break;
            }
        }
        if (!isPluralTag) {
            for (Jam jam : Jam.copy()) {
                pluralName = jam.name().toLowerCase() + "s";
                if (!name.equals(pluralName) || jam.method_8389() != item) continue;
                isPluralTag = true;
                break;
            }
        }
        if (!isPluralTag) {
            builder.method_27064(class_3497.method_43937((class_2960)itemId));
        } else {
            String category;
            builder.method_27064(class_3497.method_43937((class_2960)itemId));
            for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
                if (farmlandCrop.method_8389() != item) continue;
                pluralName = PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural());
                if (!name.equals(pluralName)) break;
                path = itemId.method_12832();
                category = farmlandCrop.getTagCategory().getLowerCaseName();
                builder.method_27064(class_3497.method_43945((class_2960)this.independentTag(category + "/" + path)));
                if (farmlandCrop.getTagCategory() == TagCategory.CROPS) break;
                builder.method_27064(class_3497.method_43945((class_2960)this.independentTag("crops/" + path)));
                break;
            }
            for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
                if (treeCrop.method_8389() != item) continue;
                pluralName = PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural());
                if (!name.equals(pluralName)) break;
                path = itemId.method_12832();
                category = treeCrop.getTagCategory().getLowerCaseName();
                builder.method_27064(class_3497.method_43945((class_2960)this.independentTag(category + "/" + path)));
                if (treeCrop.getTagCategory() != TagCategory.CROPS) {
                    builder.method_27064(class_3497.method_43945((class_2960)this.independentTag("crops/" + path)));
                }
                if (treeCrop.getTagCategory() != TagCategory.NUTS) break;
                builder.method_27064(class_3497.method_43945((class_2960)this.independentTag("fruits/" + path)));
                break;
            }
        }
        for (Juice juice : Juice.copy()) {
            if (juice.method_8389() != item) continue;
            pluralName = juice.name().toLowerCase() + "s";
            if (!name.equals(pluralName)) break;
            path = itemId.method_12832();
            builder.method_27064(class_3497.method_43945((class_2960)this.independentTag("juices/" + juice.name().toLowerCase())));
            break;
        }
        for (Jam jam : Jam.copy()) {
            if (jam.method_8389() != item) continue;
            pluralName = jam.name().toLowerCase() + "s";
            if (!name.equals(pluralName)) break;
            path = itemId.method_12832();
            builder.method_27064(class_3497.method_43945((class_2960)this.independentTag("jams/" + jam.name().toLowerCase())));
            break;
        }
    }

    private void populateGroupTags() {
        class_2960 entryForGroup;
        String pluralName;
        class_2960 entryForGroup2;
        String pluralName2;
        class_3495 fruitsGroup = this.method_27169(CroptopiaIndependentItemTagProvider.register("fruits"));
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            if (treeCrop.getTagCategory() != TagCategory.FRUITS && treeCrop.getTagCategory() != TagCategory.NUTS) continue;
            String string = PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural());
            class_2960 entryForGroup3 = this.independentTag(string);
            fruitsGroup.method_27064(class_3497.method_43945((class_2960)entryForGroup3));
        }
        class_3495 cropsGroup = this.method_27169(CroptopiaIndependentItemTagProvider.register("crops"));
        for (FarmlandCrop farmlandCrop : FarmlandCrop.FARMLAND_CROPS) {
            String pluralName22 = PluralInfo.plural(farmlandCrop.getLowercaseName(), farmlandCrop.hasPlural());
            class_2960 entryForGroup22 = this.independentTag(pluralName22);
            cropsGroup.method_27064(class_3497.method_43945((class_2960)entryForGroup22));
        }
        for (TreeCrop treeCrop : TreeCrop.TREE_CROPS) {
            if (treeCrop.getTagCategory() == TagCategory.CROPS) continue;
            pluralName2 = PluralInfo.plural(treeCrop.getLowercaseName(), treeCrop.hasPlural());
            entryForGroup2 = this.independentTag(pluralName2);
            cropsGroup.method_27064(class_3497.method_43945((class_2960)entryForGroup2));
        }
        for (Tree tree : Tree.copy()) {
            pluralName2 = PluralInfo.plural(tree.getLowercaseName(), tree.hasPlural());
            entryForGroup2 = this.independentTag(pluralName2);
            cropsGroup.method_27064(class_3497.method_43945((class_2960)entryForGroup2));
        }
        class_3495 class_34952 = this.method_27169(CroptopiaIndependentItemTagProvider.register("nuts"));
        for (TreeCrop crop : TreeCrop.TREE_CROPS) {
            if (crop.getTagCategory() != TagCategory.NUTS) continue;
            String pluralName4 = PluralInfo.plural(crop.getLowercaseName(), crop.hasPlural());
            class_2960 entryForGroup4 = this.independentTag(pluralName4);
            class_34952.method_27064(class_3497.method_43945((class_2960)entryForGroup4));
        }
        class_3495 class_34953 = this.method_27169(CroptopiaIndependentItemTagProvider.register("vegetables"));
        for (FarmlandCrop crop : FarmlandCrop.FARMLAND_CROPS) {
            if (crop.getTagCategory() != TagCategory.VEGETABLES) continue;
            pluralName = PluralInfo.plural(crop.getLowercaseName(), crop.hasPlural());
            entryForGroup = this.independentTag(pluralName);
            class_34953.method_27064(class_3497.method_43945((class_2960)entryForGroup));
        }
        for (FarmlandCrop crop : FarmlandCrop.FARMLAND_CROPS) {
            if (crop.getTagCategory() != TagCategory.FRUITS) continue;
            pluralName = PluralInfo.plural(crop.getLowercaseName(), crop.hasPlural());
            entryForGroup = this.independentTag(pluralName);
            fruitsGroup.method_27064(class_3497.method_43945((class_2960)entryForGroup));
        }
    }
}

