/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mako.network;

import net.mcreator.mako.MakoMod;
import net.mcreator.mako.procedures.IceplacefalseProcedure;
import net.mcreator.mako.procedures.IceplacetrueProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record IcekeyMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<IcekeyMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mako", (String)"key_icekey"));
    public static final StreamCodec<RegistryFriendlyByteBuf, IcekeyMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new IcekeyMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<IcekeyMessage> type() {
        return TYPE;
    }

    public static void handleData(IcekeyMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> IcekeyMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            IceplacetrueProcedure.execute((Entity)entity);
        }
        if (type == 1) {
            IceplacefalseProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MakoMod.addNetworkMessage(TYPE, STREAM_CODEC, IcekeyMessage::handleData);
    }
}

