/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mako;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber
public class GestureController {
    public static boolean thumbsUpDetected = false;
    public static boolean fistDetected = false;
    public static boolean openHandDetected = false;
    public static boolean peaceDetected = false;
    public static boolean pointDetected = false;
    public static boolean rockOnDetected = false;
    public static boolean shouldPlaceBlock = false;
    public static boolean shouldToggleSprint = false;
    public static boolean shouldStopSprint = false;
    public static boolean shouldSuperJump = false;
    public static boolean shouldTeleport = false;
    public static boolean shouldLightning = false;
    public static long lastGestureTime = 0L;
    public static String currentGesture = "none";
    public static String previousGesture = "none";
    public static boolean gestureChanged = false;
    public static boolean gestureEnabled = true;
    public static int gestureCooldownTicks = 20;
    public static double gestureConfidence = 0.0;
    public static final String JSON_PATH = "/home/brawllaunchchannel/minecraft_gestures.json";
    private static int jsonReadCounter = 0;
    private static final int JSON_READ_INTERVAL = 5;

    @SubscribeEvent
    public static void serverLoad(ServerStartingEvent event) {
        System.out.println("\u00a7a[Gesture Control] Gestartet! JSON Path: /home/brawllaunchchannel/minecraft_gestures.json");
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        CompoundTag data;
        int cooldown;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        if (!gestureEnabled) {
            return;
        }
        if (++jsonReadCounter >= 5) {
            jsonReadCounter = 0;
            GestureController.readGestureFromJSON();
        }
        int n = cooldown = (data = player.getPersistentData()).contains("gesture_cooldown") ? data.getInt("gesture_cooldown").orElse(0) : 0;
        if (cooldown > 0) {
            data.putInt("gesture_cooldown", cooldown - 1);
            return;
        }
        if (thumbsUpDetected && !previousGesture.equals("thumbs_up")) {
            shouldPlaceBlock = true;
            GestureController.triggerGestureAction(player, "thumbs_up");
        }
        if (fistDetected && !previousGesture.equals("fist")) {
            shouldToggleSprint = true;
            GestureController.triggerGestureAction(player, "fist");
        }
        if (openHandDetected && !previousGesture.equals("open_hand")) {
            shouldStopSprint = true;
            GestureController.triggerGestureAction(player, "open_hand");
        }
        if (peaceDetected && !previousGesture.equals("peace")) {
            shouldSuperJump = true;
            GestureController.triggerGestureAction(player, "peace");
        }
        if (pointDetected && !previousGesture.equals("point")) {
            shouldTeleport = true;
            GestureController.triggerGestureAction(player, "point");
        }
        if (rockOnDetected && !previousGesture.equals("rock_on")) {
            shouldLightning = true;
            GestureController.triggerGestureAction(player, "rock_on");
        }
    }

    private static void triggerGestureAction(Player player, String gestureName) {
        previousGesture = currentGesture;
        currentGesture = gestureName;
        gestureChanged = true;
        lastGestureTime = System.currentTimeMillis();
        player.getPersistentData().putInt("gesture_cooldown", gestureCooldownTicks);
    }

    private static void readGestureFromJSON() {
        try {
            File jsonFile = new File(JSON_PATH);
            if (!jsonFile.exists()) {
                GestureController.resetAllGestures();
                return;
            }
            FileReader reader = new FileReader(jsonFile);
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            reader.close();
            if (!jsonObject.has("gesture") || !jsonObject.has("active")) {
                GestureController.resetAllGestures();
                return;
            }
            String gesture = jsonObject.get("gesture").getAsString();
            boolean active = jsonObject.get("active").getAsBoolean();
            if (jsonObject.has("confidence")) {
                gestureConfidence = jsonObject.get("confidence").getAsDouble();
            }
            GestureController.resetAllGestures();
            if (active) {
                switch (gesture) {
                    case "thumbs_up": {
                        thumbsUpDetected = true;
                        break;
                    }
                    case "fist": {
                        fistDetected = true;
                        break;
                    }
                    case "open_hand": {
                        openHandDetected = true;
                        break;
                    }
                    case "peace": {
                        peaceDetected = true;
                        break;
                    }
                    case "point": {
                        pointDetected = true;
                        break;
                    }
                    case "rock_on": {
                        rockOnDetected = true;
                        break;
                    }
                    default: {
                        currentGesture = "none";
                    }
                }
            }
        }
        catch (IOException e) {
            GestureController.resetAllGestures();
            System.err.println("\u00a7c[Gesture Control] Fehler beim Lesen der JSON: " + e.getMessage());
        }
        catch (Exception e) {
            GestureController.resetAllGestures();
            System.err.println("\u00a7c[Gesture Control] JSON Parsing Fehler: " + e.getMessage());
        }
    }

    private static void resetAllGestures() {
        thumbsUpDetected = false;
        fistDetected = false;
        openHandDetected = false;
        peaceDetected = false;
        pointDetected = false;
        rockOnDetected = false;
    }

    public static void resetActionVariable(String action) {
        switch (action) {
            case "placeBlock": {
                shouldPlaceBlock = false;
                break;
            }
            case "toggleSprint": {
                shouldToggleSprint = false;
                break;
            }
            case "stopSprint": {
                shouldStopSprint = false;
                break;
            }
            case "superJump": {
                shouldSuperJump = false;
                break;
            }
            case "teleport": {
                shouldTeleport = false;
                break;
            }
            case "lightning": {
                shouldLightning = false;
                break;
            }
            case "all": {
                shouldPlaceBlock = false;
                shouldToggleSprint = false;
                shouldStopSprint = false;
                shouldSuperJump = false;
                shouldTeleport = false;
                shouldLightning = false;
                gestureChanged = false;
            }
        }
    }

    public static boolean isGestureActive(String gestureName) {
        switch (gestureName) {
            case "thumbs_up": {
                return thumbsUpDetected;
            }
            case "fist": {
                return fistDetected;
            }
            case "open_hand": {
                return openHandDetected;
            }
            case "peace": {
                return peaceDetected;
            }
            case "point": {
                return pointDetected;
            }
            case "rock_on": {
                return rockOnDetected;
            }
        }
        return false;
    }

    public static boolean shouldExecuteAction(String actionName) {
        switch (actionName) {
            case "placeBlock": {
                return shouldPlaceBlock;
            }
            case "toggleSprint": {
                return shouldToggleSprint;
            }
            case "stopSprint": {
                return shouldStopSprint;
            }
            case "superJump": {
                return shouldSuperJump;
            }
            case "teleport": {
                return shouldTeleport;
            }
            case "lightning": {
                return shouldLightning;
            }
        }
        return false;
    }

    public static String getCurrentGesture() {
        return currentGesture;
    }

    public static String getPreviousGesture() {
        return previousGesture;
    }

    public static boolean hasGestureChanged() {
        return gestureChanged;
    }

    public static double getGestureConfidence() {
        return gestureConfidence;
    }

    public static void setGestureEnabled(boolean enabled) {
        gestureEnabled = enabled;
    }

    public static boolean isGestureEnabled() {
        return gestureEnabled;
    }

    public static void setCooldownTicks(int ticks) {
        gestureCooldownTicks = Math.max(1, ticks);
    }

    public static int getCooldownTicks() {
        return gestureCooldownTicks;
    }

    public static class GestureForgeEvents {
        public static boolean isGestureActive(String gestureName) {
            return GestureController.isGestureActive(gestureName);
        }

        public static boolean shouldExecuteAction(String actionName) {
            return GestureController.shouldExecuteAction(actionName);
        }

        public static void resetActionVariable(String action) {
            GestureController.resetActionVariable(action);
        }

        public static String getCurrentGesture() {
            return GestureController.getCurrentGesture();
        }

        public static String getPreviousGesture() {
            return GestureController.getPreviousGesture();
        }

        public static boolean hasGestureChanged() {
            return GestureController.hasGestureChanged();
        }

        public static double getGestureConfidence() {
            return GestureController.getGestureConfidence();
        }

        public static void setGestureEnabled(boolean enabled) {
            GestureController.setGestureEnabled(enabled);
        }

        public static boolean isGestureEnabled() {
            return GestureController.isGestureEnabled();
        }

        public static void setCooldownTicks(int ticks) {
            GestureController.setCooldownTicks(ticks);
        }

        public static int getCooldownTicks() {
            return GestureController.getCooldownTicks();
        }
    }
}

