/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mako.fluid;

import net.mcreator.mako.init.MakoModBlocks;
import net.mcreator.mako.init.MakoModFluidTypes;
import net.mcreator.mako.init.MakoModFluids;
import net.mcreator.mako.init.MakoModItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class MoonWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)MakoModFluidTypes.MOON_WATER_TYPE.get(), () -> (Fluid)MakoModFluids.MOON_WATER.get(), () -> (Fluid)MakoModFluids.FLOWING_MOON_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)MakoModItems.MOON_WATER_BUCKET.get()).block(() -> (LiquidBlock)MakoModBlocks.MOON_WATER.get());

    private MoonWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return ParticleTypes.RAIN;
    }

    public static class Flowing
    extends MoonWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends MoonWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

