/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mako.network;

import net.mcreator.mako.MakoMod;
import net.mcreator.mako.procedures.MagnetfalseProcedure;
import net.mcreator.mako.procedures.MagnettrueProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber
public record ToggleItemMagnetMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleItemMagnetMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mako", (String)"key_toggle_item_magnet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ToggleItemMagnetMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new ToggleItemMagnetMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<ToggleItemMagnetMessage> type() {
        return TYPE;
    }

    public static void handleData(ToggleItemMagnetMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> ToggleItemMagnetMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            MagnettrueProcedure.execute((LevelAccessor)world);
        }
        if (type == 1) {
            MagnetfalseProcedure.execute((LevelAccessor)world);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        MakoMod.addNetworkMessage(TYPE, STREAM_CODEC, ToggleItemMagnetMessage::handleData);
    }
}

