/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.ComfyCozy.entity;

import bee.beeshroom.ComfyCozy.advancements.GoldAppleLambTrigger;
import bee.beeshroom.ComfyCozy.entity.EnumOatFlavor;
import bee.beeshroom.ComfyCozy.init.ModItems;
import bee.beeshroom.ComfyCozy.util.handlers.ConfigHandler;
import bee.beeshroom.ComfyCozy.util.handlers.SoundsHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityOatmealSheep
extends EntityAnimal
implements IShearable {
    private static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityOatmealSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> OAT_FLAVOR = EntityDataManager.func_187226_a(EntityOatmealSheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private int sheepTimer;
    public int oats;
    EntityAITempt temptTask;

    public EntityOatmealSheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 1.3f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.temptTask = new EntityAITempt((EntityCreature)this, 1.2, false, this.getOatFlavor().getTemptationItems());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.temptTask);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public boolean canTrample(World world, Block block, BlockPos pos, float fallDistance) {
        return false;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(6.5);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(OAT_FLAVOR, (Object)0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public void changeOatFlavor(EntityPlayer player, EnumHand hand, EnumOatFlavor flavor) {
        if (!ConfigHandler.OATSHEEPFLAVOR) {
            return;
        }
        this.setOatFlavor(flavor);
        if (flavor == EnumOatFlavor.GAPPLE && !player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            GoldAppleLambTrigger.INSTANCE.trigger((EntityPlayerMP)player);
        }
        if (!player.field_71075_bZ.field_75098_d && (player.func_184586_b(hand).func_190926_b() || player.func_184586_b(hand).func_77973_b() == flavor.getOatmealBowl())) {
            player.func_184611_a(hand, new ItemStack(Items.field_151054_z));
        } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151054_z))) {
            player.func_71019_a(new ItemStack(Items.field_151054_z), false);
        }
        this.func_184185_a(SoundsHandler.OATMEAL, 1.0f, 1.0f);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.oats > 0 && !this.getSheared() && itemstack.func_77973_b() == Items.field_151054_z && this.func_70874_b() >= 0) {
            itemstack.func_190918_g(1);
            this.func_184185_a(SoundsHandler.OATMEAL, 1.0f, 1.0f);
            if (this.oats > 0) {
                --this.oats;
            }
            if (this.oats <= 0) {
                this.setSheared(true);
                ++this.oats;
            }
            if (itemstack.func_190926_b()) {
                player.func_184611_a(hand, new ItemStack(this.getOatFlavor().getOatmealBowl()));
            } else if (!player.field_71071_by.func_70441_a(new ItemStack(this.getOatFlavor().getOatmealBowl()))) {
                player.func_71019_a(new ItemStack(this.getOatFlavor().getOatmealBowl()), false);
            }
            return true;
        }
        if (this.getSheared() && this.func_70874_b() >= 0 && (itemstack.func_77973_b() == this.getOatFlavor().getRefillItem() || itemstack.func_77973_b() == this.getOatFlavor().getOatmealBowl())) {
            if (itemstack.func_77973_b() == this.getOatFlavor().getRefillItem()) {
                itemstack.func_190918_g(1);
            }
            if (itemstack.func_77973_b() == this.getOatFlavor().getOatmealBowl() && !player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151054_z));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151054_z))) {
                    player.func_71019_a(new ItemStack(Items.field_151054_z), false);
                }
            }
            this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            this.setSheared(false);
            if (this.oats <= 0) {
                ++this.oats;
            }
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.OATMEAL && this.getOatFlavor() != EnumOatFlavor.NONE) {
            this.changeOatFlavor(player, hand, EnumOatFlavor.NONE);
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.STRAWBERRY_OATMEAL && this.getOatFlavor() != EnumOatFlavor.STRAWBERRY) {
            this.changeOatFlavor(player, hand, EnumOatFlavor.STRAWBERRY);
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.CINNAMON_OATMEAL && this.getOatFlavor() != EnumOatFlavor.CINNAMON) {
            this.changeOatFlavor(player, hand, EnumOatFlavor.CINNAMON);
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.PEACH_OATMEAL && this.getOatFlavor() != EnumOatFlavor.PEACH) {
            this.changeOatFlavor(player, hand, EnumOatFlavor.PEACH);
            return true;
        }
        if (itemstack.func_77973_b() == ModItems.GOLD_APPLE_CINNAMON_OATMEAL && this.getOatFlavor() != EnumOatFlavor.GAPPLE) {
            if (ConfigHandler.GAPPLESHEEP) {
                this.changeOatFlavor(player, hand, EnumOatFlavor.GAPPLE);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public static void registerFixesOatmealSheep(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityOatmealSheep.class);
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float p_70894_1_) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - p_70894_1_) / 4.0f : -((float)(this.sheepTimer - 40) - p_70894_1_) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float p_70890_1_) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - p_70890_1_) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74777_a("oats", (short)this.oats);
        compound.func_74774_a("Flavor", (byte)this.getOatFlavor().getMetadata());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.oats = compound.func_74765_d("oats");
        this.setOatFlavor(EnumOatFlavor.byMetadata(compound.func_74771_c("Flavor")));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    public EnumOatFlavor getOatFlavor() {
        return EnumOatFlavor.byMetadata(((Byte)this.field_70180_af.func_187225_a(OAT_FLAVOR)).byteValue());
    }

    public void setOatFlavor(EnumOatFlavor flavor) {
        this.field_70180_af.func_187227_b(OAT_FLAVOR, (Object)((byte)flavor.getMetadata()));
        this.field_70714_bg.func_85156_a((EntityAIBase)this.temptTask);
        this.temptTask = new EntityAITempt((EntityCreature)this, 1.2, false, this.getOatFlavor().getTemptationItems());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.temptTask);
    }

    public boolean getSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.field_70180_af.func_187227_b(SHEARED, (Object)sheared);
    }

    public EntityOatmealSheep createChild(EntityAgeable ageable) {
        EntityOatmealSheep other_parent = (EntityOatmealSheep)ageable;
        EntityOatmealSheep child = new EntityOatmealSheep(this.field_70170_p);
        if (this.field_70146_Z.nextInt(2) == 0) {
            child.setOatFlavor(this.getOatFlavor());
        } else {
            child.setOatFlavor(other_parent.getOatFlavor());
        }
        return child;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        ++this.oats;
        return livingdata;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 4 + this.field_70146_Z.nextInt(2);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(ModItems.OATS));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public float func_70047_e() {
        return 0.95f * this.field_70131_O;
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            for (int l = 0; l < 4; ++l) {
                int k;
                int j;
                int i = MathHelper.func_76128_c((double)(this.field_70165_t + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
                BlockPos blockpos = new BlockPos(i, j = MathHelper.func_76128_c((double)this.field_70163_u), k = MathHelper.func_76128_c((double)(this.field_70161_v + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f))));
                if (this.field_70170_p.func_180495_p(blockpos).func_185904_a() != Material.field_151579_a) continue;
                this.func_70106_y();
                this.field_70170_p.func_175656_a(blockpos, this.getOatFlavor().getDeathOatmealBowl().func_176223_P());
            }
        }
    }
}

