/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.ComfyCozy.util.handlers;

import bee.beeshroom.ComfyCozy.entity.EntityDirtyPig;
import bee.beeshroom.ComfyCozy.entity.EntityFurnaceGolem;
import bee.beeshroom.ComfyCozy.entity.EntityMushy;
import bee.beeshroom.ComfyCozy.entity.EntityOatmealSheep;
import bee.beeshroom.ComfyCozy.entity.legacy.EntityOatmealSheepCinnamon;
import bee.beeshroom.ComfyCozy.entity.legacy.EntityOatmealSheepGoldApple;
import bee.beeshroom.ComfyCozy.entity.legacy.EntityOatmealSheepPeach;
import bee.beeshroom.ComfyCozy.entity.legacy.EntityOatmealSheepStrawberry;
import bee.beeshroom.ComfyCozy.init.ModBlocks;
import bee.beeshroom.ComfyCozy.init.ModItems;
import bee.beeshroom.ComfyCozy.util.handlers.ConfigHandler;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="comfycozy")
public final class RegistryHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"comfycozy Event Subscriber");
    private static int entityId = 0;

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModItems.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])ModBlocks.BLOCKS.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onRegisterEntitiesEvent(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        ResourceLocation EntityOatmealSheep2 = new ResourceLocation("comfycozy", "entityoatmealsheep");
        ResourceLocation EntityMushy2 = new ResourceLocation("comfycozy", "entitymushy");
        ResourceLocation EntityDirtyPig2 = new ResourceLocation("comfycozy", "entitydirtypig");
        ResourceLocation EntityFurnaceGolem2 = new ResourceLocation("comfycozy", "entityfurnacegolem");
        ResourceLocation EntityOatmealSheepStrawberry2 = new ResourceLocation("comfycozy", "entityoatmealsheepstrawberry");
        ResourceLocation EntityOatmealSheepCinnamon2 = new ResourceLocation("comfycozy", "entityoatmealsheepcinnamon");
        ResourceLocation EntityOatmealSheepPeach2 = new ResourceLocation("comfycozy", "entityoatmealsheeppeach");
        ResourceLocation EntityOatmealSheepGoldApple2 = new ResourceLocation("comfycozy", "entityoatmealsheepgoldapple");
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntryBuilder.create().entity(EntityOatmealSheep.class).egg(16768180, 15447932).id(EntityOatmealSheep2, entityId++).name(EntityOatmealSheep2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityMushy.class).egg(13639962, 16182236).id(EntityMushy2, entityId++).name(EntityMushy2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityDirtyPig.class).egg(13799274, 7490088).id(EntityDirtyPig2, entityId++).name(EntityDirtyPig2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityFurnaceGolem.class).id(EntityFurnaceGolem2, entityId++).name(EntityFurnaceGolem2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityOatmealSheepStrawberry.class).id(EntityOatmealSheepStrawberry2, entityId++).name(EntityOatmealSheepStrawberry2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityOatmealSheepCinnamon.class).id(EntityOatmealSheepCinnamon2, entityId++).name(EntityOatmealSheepCinnamon2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityOatmealSheepPeach.class).id(EntityOatmealSheepPeach2, entityId++).name(EntityOatmealSheepPeach2.func_110623_a()).tracker(80, 3, false).build(), EntityEntryBuilder.create().entity(EntityOatmealSheepGoldApple.class).id(EntityOatmealSheepGoldApple2, entityId++).name(EntityOatmealSheepGoldApple2.func_110623_a()).tracker(80, 3, false).build()});
        LOGGER.debug("Registered entities");
        RegistryHandler.addSpawns();
    }

    private static void addSpawns() {
        if (ConfigHandler.SHROOMINI) {
            EntityRegistry.addSpawn(EntityMushy.class, (int)5, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.MUSHROOM));
            EntityRegistry.addSpawn(EntityMushy.class, (int)45, (int)2, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.SPOOKY));
            EntityRegistry.addSpawn(EntityMushy.class, (int)35, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.SWAMP));
            if (ConfigHandler.SHROOMINI_FORESTS) {
                EntityRegistry.addSpawn(EntityMushy.class, (int)7, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.FOREST));
            }
        }
        if (ConfigHandler.DIRTY_PIG) {
            EntityRegistry.addSpawn(EntityDirtyPig.class, (int)25, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.SWAMP));
            if (ConfigHandler.DIRTY_PIG_FORESTS) {
                EntityRegistry.addSpawn(EntityDirtyPig.class, (int)20, (int)1, (int)1, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])RegistryHandler.getBiomes(BiomeDictionary.Type.FOREST));
            }
        }
    }

    private static Biome[] getBiomes(BiomeDictionary.Type type) {
        return BiomeDictionary.getBiomes((BiomeDictionary.Type)type).toArray(new Biome[0]);
    }

    @SubscribeEvent
    public static void furnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_WHITE)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_RED)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_YELLOW)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_GREEN)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_LIGHT_BLUE)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.AWNING_PINK)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.CINNAMON_SAPLING)) {
            event.setBurnTime(5);
        }
        if (event.getItemStack().func_77973_b() == ModItems.COZY_HAMMER) {
            event.setBurnTime(5);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.TABLE)) {
            event.setBurnTime(15);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.POLE)) {
            event.setBurnTime(10);
        }
        if (event.getItemStack().func_77973_b() == ModItems.CINNAMON_STICK) {
            event.setBurnTime(10);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.CARP_BANNER)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.CARP_BANNER_2)) {
            event.setBurnTime(12);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.BUNTING)) {
            event.setBurnTime(2);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.BUNTING_CHECK)) {
            event.setBurnTime(2);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.BUNTING_HEART)) {
            event.setBurnTime(2);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.CUSHION_RED)) {
            event.setBurnTime(10);
        }
        if (event.getItemStack().func_77973_b() == Item.func_150898_a((Block)ModBlocks.CUSHION_SILVER)) {
            event.setBurnTime(10);
        }
    }
}

