/*
 * Decompiled with CFR 0.152.
 */
package bee.beeshroom.ComfyCozy.world.generation.generators;

import bee.beeshroom.ComfyCozy.world.generation.generators.WorldGenCinnamon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeForest;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenTrees
implements IWorldGenerator {
    private final WorldGenerator CINNAMON = new WorldGenCinnamon(true);

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case 1: {
                break;
            }
            case 0: {
                this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 85, (Block)Blocks.field_150349_c, BiomeJungle.class);
                this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 85, Blocks.field_150346_d, BiomeJungle.class);
                this.runGenerator(this.CINNAMON, world, random, chunkX, chunkZ, 15, (Block)Blocks.field_150349_c, BiomeForest.class);
                break;
            }
        }
    }

    private void runGenerator(WorldGenerator generator, World world, Random random, int chunkX, int chunkZ, int chance, Block topBlock, Class<?> ... classes) {
        ArrayList classesList = new ArrayList(Arrays.asList(classes));
        int x = chunkX * 16 + random.nextInt(15);
        int z = chunkZ * 16 + random.nextInt(15);
        int y = WorldGenTrees.calculateGenerationHeight(world, x, z, topBlock);
        BlockPos pos = new BlockPos(x, y, z);
        Class<?> biome = world.field_73011_w.getBiomeForCoords(pos).getClass();
        if (world.func_175624_G() != WorldType.field_77138_c && classesList.contains(biome) && random.nextInt(chance) == 0) {
            generator.func_180709_b(world, random, pos);
        }
    }

    private static int calculateGenerationHeight(World world, int x, int z, Block topBlock) {
        int y = world.func_72800_K();
        boolean foundGround = false;
        while (!foundGround && y-- >= 0) {
            Block block = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
            foundGround = block == topBlock;
        }
        return y;
    }
}

